#!/usr/bin/perl

# Copyright 2013 ByWater Solutions
#
# This file is part of Koha.
#
# Koha is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# Koha is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Koha; if not, see <http://www.gnu.org/licenses>.

use Modern::Perl;

use CGI qw ( -utf8 );

use C4::Auth qw( get_template_and_user );
use C4::Output;
use Koha::List::Patron qw( DelPatronList );

my $cgi = CGI->new;

my ( $template, $loggedinuser, $cookie ) = get_template_and_user(
    {
        template_name => "patron_lists/lists.tt",
        query         => $cgi,
        type          => "intranet",
        flagsrequired => { tools => 'manage_patron_lists' },
    }
);

my $id        = $cgi->param('patron_list_id');
my @lists_ids = $cgi->multi_param('patron_lists_ids');

if ( defined $id && $id ne '' ) {
    DelPatronList( { patron_list_id => $id } );
}
if (@lists_ids) {
    foreach my $list_id (@lists_ids) {
        DelPatronList( { patron_list_id => $list_id } );
    }
}

print $cgi->redirect('lists.pl');
