INSERT INTO systempreferences ( `variable`, `value`, `options`, `explanation`, `type` ) VALUES
('AccessControlAllowOrigin', '', NULL, 'Set the Access-Control-Allow-Origin header to the specified value', 'Free'),
('AccountAutoReconcile','0',NULL,'If enabled, patron balances will get reconciled automatically on each transaction.','YesNo'),
('AcqCreateItem','ordering','ordering|receiving|cataloguing','Define when the item is created : when ordering, when receiving, or in cataloguing module','Choice'),
('AcqEnableFiles','0',NULL,'If enabled, allows librarians to upload and attach arbitrary files to invoice records.','YesNo'),
('AcqItemSetSubfieldsWhenReceiptIsCancelled','', '','Upon cancelling a receipt, update the items subfields if they were created when placing an order (e.g. o=5|a="bar foo")', 'Free'),
('AcqItemSetSubfieldsWhenReceived','','','Upon receiving items, update their subfields if they were created when placing an order (e.g. o=5|a="foo bar")','Free'),
('AcquisitionDetails', '1', '', 'Hide/Show acquisition details on the biblio detail page.', 'YesNo'),
('AcquisitionLog','0',NULL,'If ON, log acquisitions activity','YesNo'),
('AcquisitionsDefaultEmailAddress', '', NULL, 'Default email address  that acquisition notices are sent from', 'Free'),
('AcquisitionsDefaultReplyTo', '', NULL, "Default email address used as reply-to for notices sent by the acquisitions module.", 'Free'),
('AcqViewBaskets','user','user|branch|all','Define which baskets a user is allowed to view: their own only, any within their branch, or all','Choice'),
('AcqWarnOnDuplicateInvoice','0','','Warn librarians when they try to create a duplicate invoice','YesNo'),
('ActionLogsTraceDepth', '0', '', 'Sets the maximum depth of the action logs stack trace', 'Integer'),
('AdditionalContentsEditor','tinymce','tinymce|codemirror','Choose tool for editing News.', 'Choice'),
('AdditionalFieldsInZ3950ResultAuthSearch', '', NULL, 'Determines which MARC field/subfields are displayed in -Additional field- column in the result of an authority Z39.50 search', 'Free'),
('AdditionalFieldsInZ3950ResultSearch', '', NULL, 'Determines which MARC field/subfields are displayed in -Additional field- column in the result of a search Z3950', 'Free'),
('AddressForFailedOverdueNotices', '', NULL, 'Destination email for failed overdue notices. If left empty then it will fallback to the first defined address in the following list: Library ReplyTo, Library Email, ReplytoDefault and KohaAdminEmailAddress', 'free'),
('AddressFormat','us','us|de|fr','Choose format to display postal addresses', 'Choice'),
('advancedMARCeditor','0','','If ON, the MARC editor won\'t display field/subfield descriptions','YesNo'),
('AdvancedSearchLanguages','','','ISO 639-2 codes of languages you wish to see appear as an Advanced search option.  Example: eng|fre|ita','Textarea'),
('AdvancedSearchTypes','itemtypes','itemtypes|ccode','Select which set of fields comprise the Type limit in the advanced search','Choice'),
('AgeRestrictionMarker','',NULL,'Markers for age restriction indication, e.g. FSK|PEGI|Age|','free'),
('AgeRestrictionOverride','0',NULL,'Allow staff to check out an item with age restriction.','YesNo'),
('AggressiveMatchOnISBN','0', NULL,'If enabled, attempt to match aggressively by trying all variations of the ISBNs in the imported record as a phrase in the ISBN fields of already cataloged records when matching on ISBN with the record import tool','YesNo'),
('AggressiveMatchOnISSN','0', NULL,'If enabled, attempt to match aggressively by trying all variations of the ISSNs in the imported record as a phrase in the ISSN fields of already cataloged records when matching on ISSN with the record import tool','YesNo'),
('AllFinesNeedOverride','1','0','If on, staff will be asked to override every fine, even if it is below noissuescharge.','YesNo'),
('AllowAllMessageDeletion','0','','Allow any Library to delete any message','YesNo'),
('AllowCheckoutNotes', '0', NULL, 'Allow patrons to submit notes about checked out items.','YesNo'),
('AllowFineOverride','0','0','If on, staff will be able to issue books to patrons with fines greater than noissuescharge.','YesNo'),
('AllowHoldDateInFuture','0','','If set a date field is displayed on the Hold screen of the Staff Interface, allowing the hold date to be set in the future.','YesNo'),
('AllowHoldItemTypeSelection','0','','If enabled, patrons and staff will be able to select the itemtype when placing a hold','YesNo'),
('AllowHoldPolicyOverride','0',NULL,'Allow staff to override hold policies when placing holds','YesNo'),
('AllowHoldsOnDamagedItems','1','','Allow hold requests to be placed on damaged items','YesNo'),
('AllowHoldsOnPatronsPossessions','1',NULL,'Allow holds on records that patron have items of it','YesNo'),
('AllowItemsOnHoldCheckoutSCO','0','','Do not generate RESERVE_WAITING and RESERVED warning in the SCO module when checking out items reserved to someone else. This allows self checkouts for those items.','YesNo'),
('AllowItemsOnHoldCheckoutSIP','0','','Do not generate RESERVED warning when checking out items reserved to someone else via SIP. This allows self checkouts for those items.','YesNo'),
('AllowMultipleCovers','0','1','Allow multiple cover images to be attached to each bibliographic record.','YesNo'),
('AllowMultipleIssuesOnABiblio',1,'Allow/Don\'t allow patrons to check out multiple items from one biblio','','YesNo'),
('AllowNotForLoanOverride','0','','If ON, Koha will allow the librarian to loan a not for loan item.','YesNo'),
('AllowPatronToControlAutorenewal','0',NULL,'If enabled, patrons will have a field in their account to choose whether their checkouts are auto renewed or not','YesNo'),
('AllowPatronToSetCheckoutsVisibilityForGuarantor',  '0', NULL, 'If enabled, the patron can set checkouts to be visible to their guarantor',  'YesNo'),
('AllowPatronToSetFinesVisibilityForGuarantor',  '0', NULL, 'If enabled, the patron can set fines to be visible to their guarantor',  'YesNo'),
('AllowPKIAuth','None','None|Common Name|emailAddress','Use the field from a client-side SSL certificate to look a user in the Koha database','Choice'),
('AllowRenewalIfOtherItemsAvailable','0',NULL,'If enabled, allow a patron to renew an item with unfilled holds if other available items can fill that hold.','YesNo'),
('AllowRenewalLimitOverride','0',NULL,'if ON, allows renewal limits to be overridden on the circulation screen','YesNo'),
('AllowRenewalOnHoldOverride','0',NULL,'If ON, allow items on hold to be renewed with a specified due date','YesNo'),
('AllowReturnToBranch','anywhere','anywhere|homebranch|holdingbranch|homeorholdingbranch','Where an item may be returned','Choice'),
('AllowSetAutomaticRenewal','1',NULL,'If ON, allows staff to flag items for automatic renewal on the check out page','YesNo'),
('AllowStaffToSetCheckoutsVisibilityForGuarantor','0',NULL,'If enabled, library staff can set a patron''s checkouts to be visible to linked patrons from the opac.',  'YesNo'),
('AllowStaffToSetFinesVisibilityForGuarantor','0',NULL,'If enabled, library staff can set a patron''s fines to be visible to linked patrons from the opac.',  'YesNo'),
('AllowTooManyOverride','1','','If on, allow staff to override and check out items when the patron has reached the maximum number of allowed checkouts','YesNo'),
('alphabet','A B C D E F G H I J K L M N O P Q R S T U V W X Y Z',NULL,'Alphabet than can be expanded into browse links, e.g. on Home > Patrons','free'),
('AlternateHoldingsField','',NULL,'The MARC field/subfield that contains alternate holdings information for bibs taht do not have items attached (e.g. 852abchi for libraries converting from MARC Magician).','free'),
('AlternateHoldingsSeparator','',NULL,'The string to use to separate subfields in alternate holdings displays.','free'),
('AmazonAssocTag','','','See:  http://aws.amazon.com','free'),
('AmazonCoverImages','0','','Display Cover Images in staff interface from Amazon Web Services','YesNo'),
('AmazonLocale','US','US|CA|DE|FR|IN|JP|UK','Use to set the Locale of your Amazon.com Web Services','Choice'),
('AnonSuggestions','0',NULL,'Set to enable Anonymous suggestions to AnonymousPatron borrowernumber','YesNo'),
('AnonymousPatron','0',NULL,'Set the identifier (borrowernumber) of the anonymous patron. Used for suggestion and checkout history privacy',''),
('ApplyFrameworkDefaults', 'new', 'new|duplicate|changed|imported', 'Configure when to apply framework default values - when cataloguing a new record, or when editing a record as new (duplicating), or when changing framework, or when importing a record', 'multiple'),
('ArticleRequests', '0', NULL, 'Enables the article request feature', 'YesNo'),
('ArticleRequestsLinkControl', 'calc', 'always|calc', 'Control display of article request link on search results', 'Choice'),
('ArticleRequestsMandatoryFields', '', NULL, 'Comma delimited list of required fields for bibs where article requests rule = ''yes''', 'multiple'),
('ArticleRequestsMandatoryFieldsItemOnly', '', NULL, 'Comma delimited list of required fields for bibs where article requests rule = ''item_only''', 'multiple'),
('ArticleRequestsMandatoryFieldsRecordOnly', '', NULL, 'Comma delimited list of required fields for bibs where article requests rule = ''bib_only''', 'multiple'),
('ArticleRequestsOpacHostRedirection', '0', NULL, 'Enables redirection from child to host when requesting articles on the Opac', 'YesNo'),
('ArticleRequestsSupportedFormats', 'PHOTOCOPY', 'PHOTOCOPY|SCAN', 'List supported formats between vertical bars', 'free'),
('AudioAlerts','0','','Enable circulation sounds during checkin and checkout in the staff interface.  Not supported by all web browsers yet.','YesNo'),
('AuthDisplayHierarchy','0','','Display authority hierarchies','YesNo'),
('AuthFailureLog','0',NULL,'If enabled, log authentication failures','YesNo'),
('AuthoritiesLog','1',NULL,'If ON, log edit/create/delete actions on authorities.','YesNo'),
('AuthorityControlledIndicators','# PERSO_NAME  100 600 696 700 796 800 896\nmarc21, 100, ind1:auth1\nmarc21, 600, ind1:auth1, ind2:thesaurus\nmarc21, 696, ind1:auth1\nmarc21, 700, ind1:auth1\nmarc21, 796, ind1:auth1\nmarc21, 800, ind1:auth1\nmarc21, 896, ind1:auth1\n# CORPO_NAME  110 610 697 710 797 810 897\nmarc21, 110, ind1:auth1\nmarc21, 610, ind1:auth1, ind2:thesaurus\nmarc21, 697, ind1:auth1\nmarc21, 710, ind1:auth1\nmarc21, 797, ind1:auth1\nmarc21, 810, ind1:auth1\nmarc21, 897, ind1:auth1\n# MEETI_NAME    111 611 698 711 798 811 898\nmarc21, 111, ind1:auth1\nmarc21, 611, ind1:auth1, ind2:thesaurus\nmarc21, 698, ind1:auth1\nmarc21, 711, ind1:auth1\nmarc21, 798, ind1:auth1\nmarc21, 811, ind1:auth1\nmarc21, 898, ind1:auth1\n# UNIF_TITLE        130 440 630 699 730 799 830 899\nmarc21, 130, ind1:auth2\nmarc21, 240, , ind2:auth2\nmarc21, 440, , ind2:auth2\nmarc21, 630, ind1:auth2, ind2:thesaurus\nmarc21, 699, ind1:auth2\nmarc21, 730, ind1:auth2\nmarc21, 799, ind1:auth2\nmarc21, 830, , ind2:auth2\nmarc21, 899, ind1:auth2\n# CHRON_TERM    648 \nmarc21, 648, , ind2:thesaurus\n# TOPIC_TERM      650 654 656 657 658 690\nmarc21, 650, , ind2:thesaurus\n# GEOGR_NAME   651 662 691\nmarc21, 651, , ind2:thesaurus\n# GENRE/FORM    655 \nmarc21, 655, , ind2:thesaurus\n\n# UNIMARC: Always copy the indicators from the authority\nunimarc, *, ind1:auth1, ind2:auth2',NULL,'Authority controlled indicators per biblio field','Free'),
('AuthorityMergeLimit','50',NULL,'Maximum number of biblio records updated immediately when an authority record has been modified.','integer'),
('AuthorityMergeMode','loose','loose|strict','Authority merge mode','Choice'),
('AuthoritySeparator','--','10','Used to separate a list of authorities in a display. Usually --','free'),
('AuthorityXSLTOpacDetailsDisplay','','','Enable XSL stylesheet control over authority details page in the OPAC','Free'),
('AuthorityXSLTOpacResultsDisplay','','','Enable XSL stylesheet control over authority results page in the OPAC','Free'),
('AuthorityXSLTResultsDisplay','','','Enable XSL stylesheet control over authority results page display on intranet','Free'),
('AuthorLinkSortBy','default','call_number|pubdate|acqdate|title','Specify the default field used for sorting when click author links','Choice'),
('AuthorLinkSortOrder','asc','asc|dsc|az|za','Specify the default sort order for author links','Choice'),
('AuthSuccessLog','0',NULL,'If enabled, log successful authentications','YesNo'),
('AutoApprovePatronProfileSettings', '0', '', 'Automatically approve patron profile changes from the OPAC.', 'YesNo'),
('autoBarcode','OFF','incremental|annual|hbyymmincr|EAN13|OFF','Used to autogenerate a barcode: incremental will be of the form 1, 2, 3; annual of the form 2007-0001, 2007-0002; hbyymmincr of the form HB08010001 where HB=Home Branch','Choice'),
('autoControlNumber','OFF','biblionumber|OFF','Used to autogenerate a Control Number: biblionumber will be as biblionumber, OFF will leave the field as it is;','Choice'),
('AutoCreateAuthorities','0',NULL,'Automatically create authorities that do not exist when cataloging records.','YesNo'),
('AutoCreditNumber', '', '', 'Automatically generate a number for account credits', 'Choice'),
('AutoEmailNewUser','0',NULL,'Send an email to newly created patrons.','YesNo'),
('AutoLinkBiblios','0',NULL,'If enabled, link biblio to authorities on creation and edit','YesNo'),
('AutomaticCheckinAutoFill','0',NULL,'Automatically fill the next hold with an automatic check in.','YesNo'),
('AutomaticConfirmTransfer','0',NULL,'Defines whether transfers should be automatically confirmed at checkin if modal dismissed','YesNo'),
('AutomaticItemReturn','1',NULL,'If ON, Koha will automatically set up a transfer of this item to its homebranch','YesNo'),
('autoMemberNum','0','','If ON, patron number is auto-calculated','YesNo'),
('AutoRemoveOverduesRestrictions','no','no|when_no_overdue|when_no_overdue_causing_debarment', 'Defines if and on what conditions OVERDUES debarments should automatically be lifted when overdue items are returned by the patron.','Choice'),
('AutoRenewalNotices','preferences','cron|preferences|never','How should Koha determine whether to end autorenewal notices','Choice'),
('AutoResumeSuspendedHolds','1',NULL,'Allow suspended holds to be automatically resumed by a set date.','YesNo'),
('AutoReturnCheckedOutItems', '0', '', 'If disabled, librarian must confirm return of checked out item when checking out to another.', 'YesNo'),
('AutoSelfCheckAllowed','0','','For corporate and special libraries which want web-based self-check available from any PC without the need for a manual staff login. Most libraries will want to leave this turned off. If on, requires self-check ID and password to be entered in AutoSelfCheckID and AutoSelfCheckPass sysprefs.','YesNo'),
('AutoSelfCheckID','','','Staff ID with circulation rights to be used for automatic web-based self-check. Only applies if AutoSelfCheckAllowed syspref is turned on.','free'),
('AutoSelfCheckPass','','','Password to be used for automatic web-based self-check. Only applies if AutoSelfCheckAllowed syspref is turned on.','free'),
('AutoShareWithMana','subscription','','defines datas automatically shared with mana','multiple'),
('AutoSwitchPatron', '0', '', 'Auto switch to patron', 'YesNo'),
('Babeltheque','0','','Turn ON Babeltheque content  - See babeltheque.com to subscribe to this service','YesNo'),
('Babeltheque_url_js','','','Url for Babeltheque javascript (e.g. http://www.babeltheque.com/bw_XX.js)','Free'),
('Babeltheque_url_update','','','Url for Babeltheque update (E.G. http://www.babeltheque.com/.../file.csv.bz2)','Free'),
('BakerTaylorBookstoreURL','','','URL template for \"My Libary Bookstore\" links, to which the \"key\" value is appended, and \"https://\" is prepended.  It should include your hostname and \"Parent Number\".  Make this variable empty to turn MLB links off.  Example: ocls.mylibrarybookstore.com/MLB/actions/searchHandler.do?nextPage=bookDetails&parentNum=10923&key=',''),
('BakerTaylorEnabled','0','','Enable or disable all Baker & Taylor features.','YesNo'),
('BakerTaylorPassword','','','Baker & Taylor Password for Content Cafe (external content)','Free'),
('BakerTaylorUsername','','','Baker & Taylor Username for Content Cafe (external content)','Free'),
('BarcodeSeparators','\\s\\r\\n','','Splitting characters for barcodes','Free'),
('BasketConfirmations','1','always ask for confirmation.|do not ask for confirmation.','When closing or reopening a basket,','Choice'),
('BatchCheckouts','0','','Enable or disable batch checkouts','YesNo'),
('BatchCheckoutsValidCategories','',NULL,'Patron categories allowed to checkout in a batch','Free'),
('BiblioDefaultView','normal','normal|marc|isbd','Choose the default detail view in the catalog; choose between normal, marc or isbd','Choice'),
('BiblioItemtypeInfo','0','0','Control which itemtype info displays for biblio level itemtypes','YesNo'),
('BibtexExportAdditionalFields',  '', NULL ,  'Define additional BibTex tags to export from MARC records in YAML format as an associative array with either a marc tag/subfield combination as the value, or a list of tag/subfield combinations.',  'textarea'),
('BlockExpiredPatronOpacActions','1',NULL,'Set whether an expired patron can perform opac actions such as placing holds or renew books, can be overridden on a per patron-type basis','YesNo'),
('BlockReturnOfLostItems','0','0','If enabled, items that are marked as lost cannot be returned.','YesNo'),
('BlockReturnOfWithdrawnItems','1','0','If enabled, items that are marked as withdrawn cannot be returned.','YesNo'),
('BorrowerMandatoryField','surname|cardnumber',NULL,'Choose the mandatory fields for a patron\'s account','free'),
('borrowerRelationship','father|mother','','Define valid relationships between a guarantor & a guarantee (separated by | or ,)','free'),
('BorrowerRenewalPeriodBase','now','dateexpiry|now|combination','Set whether the borrower renewal date should be counted from the dateexpiry, from the current date or by combination: if the dateexpiry is in future use dateexpiry, else use current date ','Choice'),
('BorrowersLog','1',NULL,'If ON, log edit/create/delete actions on patron data','YesNo'),
('BorrowersTitles','Mr|Mrs|Miss|Ms',NULL,'Define appropriate Titles for patrons','free'),
('BorrowerUnwantedField','',NULL,'Name the fields you don\'t need to store for a patron\'s account','free'),
('BranchTransferLimitsType','ccode','itemtype|ccode','When using branch transfer limits, choose whether to limit by itemtype or collection code.','Choice'),
('BrowseResultSelection','0',NULL,'Enable/Disable browsing search results fromt the bibliographic record detail page in staff interface','YesNo'),
('BundleLostValue','5',NULL,'Sets the LOST AV value that represents "Missing from bundle" as a lost value','Free'),
('BundleNotLoanValue','3',NULL,'Sets the NOT_LOAN AV value that represents "Added to bundle" as a not for loan value','Free'),
('CalculateFinesOnBackdate','1','','Switch to control if overdue fines are calculated on return when backdating','YesNo'),
('CalculateFinesOnReturn','1','','Switch to control if overdue fines are calculated on return or not','YesNo'),
('CalculateFundValuesIncludingTax', '1', NULL, 'Include tax in the calculated fund values (spent, ordered) for all supplier configurations', 'YesNo'),
('CalendarFirstDayOfWeek','0','0|1|2|3|4|5|6','Select the first day of week to use in the calendar.','Choice'),
('CancelOrdersInClosedBaskets', '0', NULL, 'Allow/Do not allow cancelling order lines in closed baskets.', 'YesNo'),
('CanMarkHoldsToPullAsLost','do_not_allow','do_not_allow|allow|allow_and_notify','Add a button to the "Holds to pull" screen to mark an item as lost and notify the patron.','Choice'),
('canreservefromotherbranches','1','','With Independent branches on, can a user from one library place a hold on an item from another library','YesNo'),
('CardnumberLength', '', '', 'Set a length for card numbers with a maximum of 32 characters.', 'Free'),
('casAuthentication','0','','Enable or disable CAS authentication','YesNo'),
('casLogout','0','','Does a logout from Koha should also log the user out of CAS?','YesNo'),
('casServerUrl','https://localhost:8443/cas','','URL of the cas server','Free'),
('casServerVersion','2', '2|3','Version of the CAS server Koha will connect to.','Choice'),
('CatalogConcerns', '0', NULL, 'Allow users to report catalog concerns', 'YesNo'),
('CatalogerEmails', '', '', 'Notify these catalogers by email when a catalog concern is submitted', 'free'),
('CatalogModuleRelink','0',NULL,'If OFF the linker will never replace the authids that are set in the cataloging module.','YesNo'),
('CataloguingLog','1',NULL,'If ON, log edit/create/delete actions on bibliographic data. WARNING: this feature is very resource consuming.','YesNo'),
('ChargeFinesOnClosedDays','0',NULL,'Charge fines on days the library is closed.','YesNo'),
('CheckPrevCheckout','hardno','hardyes|softyes|softno|hardno','By default, for every item checked out, should we warn if the patron has borrowed that item in the past?','Choice'),
('CheckPrevCheckoutDelay','0', NULL,'Maximum number of days that will trigger a warning if the patron has borrowed that item in the past when CheckPrevCheckout is enabled.','free'),
('ChildNeedsGuarantor', 0, 'If ON, a child patron must have a guarantor when adding the patron.', '', 'YesNo'),
('CircAutoPrintQuickSlip','qslip',NULL,'Choose what should happen when an empty barcode field is submitted in circulation: Display a print quick slip window, Display a print slip window, Do nothing, or Clear the screen.','Choice'),
('CircConfirmItemParts', '0', NULL, 'Require staff to confirm that all parts of an item are present at checkin/checkout.', 'Yes/No'),
('CircControl','ItemHomeLibrary','PickupLibrary|PatronLibrary|ItemHomeLibrary','Specify the agency that controls the circulation and fines policy','Choice'),
('CircControlReturnsBranch','ItemHomeLibrary','ItemHomeLibrary|ItemHoldingLibrary|CheckInLibrary','Specify the agency that controls the return policy','Choice'),
('CircSidebar','1',NULL,'Activate or deactivate the navigation sidebar on all Circulation pages','YesNo'),
('CirculateILL','0','','If enabled, it is possible to circulate ILL items from within ILL','YesNo'),
('ClaimReturnedChargeFee', 'ask', 'ask|charge|no_charge', 'Controls whether or not a lost item fee is charged for return claims', 'Choice'),
('ClaimReturnedLostValue', '', '', 'Sets the LOST AV value that represents "Claims returned" as a lost value', 'Free'),
('ClaimReturnedWarningThreshold', '', '', 'Sets the number of return claims past which the librarian will be warned the patron has many return claims', 'Integer'),
('ClaimsBccCopy','0','','Bcc the ClaimAcquisition and ClaimIssues alerts','YesNo'),
('ClaimsLog','1',NULL,'If ON, log all notices sent','YesNo'),
('CleanUpDatabaseReturnClaims', '', '', 'Sets the age of resolved return claims to delete from the database for cleanup_database.pl', 'Integer' ),
('CoceHost', '', NULL, 'Coce server URL', 'Free'),
('CoceProviders', '', 'aws,gb,ol', 'Coce providers', 'multiple'),
('COinSinOPACResults','1','','If ON, use COinS in OPAC search results page.  NOTE: this can slow down search response time significantly','YesNo'),
('CollapseFieldsPatronAddForm','',NULL,'Collapse these fields by default when adding a new patron. These fields can still be expanded.','Multiple'),
('ComponentSortField','title','call_number|pubdate|acqdate|title|author','Specify the default field used for sorting','Choice'),
('ComponentSortOrder','asc','asc|dsc|az|za','Specify the default sort order','Choice'),
('ConfirmFutureHolds','0','','Number of days for confirming future holds','Integer'),
('ConsiderOnSiteCheckoutsAsNormalCheckouts','1',NULL,'Consider on-site checkouts as normal checkouts','YesNo'),
('ContentWarningField', '', NULL, 'MARC field to use for content warnings', 'Free'),
('CookieConsent', '0', NULL, 'Require cookie consent to be displayed', 'YesNo'),
('CookieConsentedJS', '', NULL, 'Add Javascript code that will run if cookie consent is provided (e.g. tracking code).', 'Free'),
('CreateAVFromCataloguing', '1', '', 'Ability to create authorized values from the cataloguing module', 'YesNo'),
('CronjobLog','0',NULL,'If ON, log information from cron jobs.','YesNo'),
('CSVDelimiter',',',';|tabulation|,|/|\\|#||','Define the default separator character for exporting reports','Choice'),
('CumulativeRestrictionPeriods',0,NULL,'Cumulate the restriction periods instead of keeping the highest','YesNo'),
('CurbsidePickup', '0', NULL, 'Enable curbside pickup', 'YesNo'),
('CurrencyFormat','US','US|FR|CH','Determines the display format of currencies. eg: \'36000\' is displayed as \'360 000,00\'  in \'FR\' or \'360,000.00\'  in \'US\'.','Choice'),
('CustomCoverImages','0',NULL,'If enabled, the custom cover images will be displayed in the staff interface. CustomCoverImagesURL must be defined.','YesNo'),
('CustomCoverImagesURL','',NULL,'Define an URL serving book cover images, using the following patterns: %issn%, %isbn%, FIXME ADD MORE (use it with CustomCoverImages and/or OPACCustomCoverImages)','free'),
('dateformat','us','metric|us|iso|dmydot','Define global date format (us mm/dd/yyyy, metric dd/mm/yyy, ISO yyyy-mm-dd, dmydot dd.mm.yyyy)','Choice'),
('DebugLevel','2','0|1|2','Define the level of debugging information sent to the browser when errors are encountered (set to 0 in production). 0=none, 1=some, 2=most','Choice'),
('decreaseLoanHighHolds','0','','Decreases the loan period for items with number of holds above the threshold specified in decreaseLoanHighHoldsValue','YesNo'),
('decreaseLoanHighHoldsControl', 'static', 'static|dynamic', "Chooses between static and dynamic high holds checking", 'Choice'),
('decreaseLoanHighHoldsDuration',NULL,'','Specifies a number of days that a loan is reduced to when used in conjunction with decreaseLoanHighHolds','Integer'),
('decreaseLoanHighHoldsIgnoreStatuses', '', 'damaged|itemlost|notforloan|withdrawn', "Ignore items with these statuses for dynamic high holds checking", 'Choice'),
('decreaseLoanHighHoldsValue',NULL,'','Specifies a threshold for the minimum number of holds needed to trigger a reduction in loan duration (used with decreaseLoanHighHolds)','Integer'),
('DefaultAuthorityTab','0','0|1|2|3|4|5|6|7|8|9','Default tab to shwo when displaying authorities','Choice'),
('DefaultClassificationSource','ddc',NULL,'Default classification scheme used by the collection. E.g., Dewey, LCC, etc.','ClassSources'),
('DefaultCountryField008','','','Fill in the default country code for field 008 Range 15-17 of MARC21 - Place of publication, production, or execution. See <a href=\"http://www.loc.gov/marc/countries/countries_code.html\">MARC Code List for Countries</a>','Free'),
('DefaultHoldExpirationdate','0','','Automatically set expiration date for holds','YesNo'),
('DefaultHoldExpirationdatePeriod','0','','How long into the future default expiration date is set to be.','integer'),
('DefaultHoldExpirationdateUnitOfTime','days','days|months|years','Which unit of time is used when setting the default expiration date. ','choice'),
('DefaultHoldPickupLocation','loggedinlibrary','loggedinlibrary|homebranch|holdingbranch','Which branch should a hold pickup location default to. ','choice'),
('DefaultLanguageField008','','','Fill in the default language for field 008 Range 35-37 of MARC21 records (e.g. eng, nor, ger, see <a href=\"http://www.loc.gov/marc/languages/language_code.html\">MARC Code List for Languages</a>)','Free'),
('DefaultLongOverdueChargeValue', '', NULL, "Charge a lost item to the borrower's account when the LOST value of the item changes to n.", 'integer'),
('DefaultLongOverdueDays', '', NULL, "Set the LOST value of an item when the item has been overdue for more than n days.", 'integer'),
('DefaultLongOverdueLostValue', '', NULL, "Set the LOST value of an item to n when the item has been overdue for more than defaultlongoverduedays days.", 'integer'),
('DefaultLongOverdueSkipLostStatuses', '', NULL, 'Skip these lost statuses by default in longoverdue.pl', 'Free'),
('DefaultPatronSearchFields',    'firstname|middle_name|surname|othernames|cardnumber|userid',NULL,'Pipe separated list defining the default fields to be used during a patron search using the "standard" option. If empty Koha will default to "firstname|surname|othernames|cardnumber|userid". Additional fields added to this preference will be added as search options in the dropdown menu on the patron search page.','free'),
('DefaultPatronSearchMethod','starts_with','Choose which search method to use by default when searching with PatronAutoComplete','starts_with|contains','Choice'),
('DefaultSaveRecordFileID','biblionumber','biblionumber|controlnumber','Defines whether the advanced cataloging editor will use the bibliographic record number or control number field to populate the name of the save file','Choice'),
('defaultSortField','relevance','relevance|popularity|call_number|pubdate|acqdate|title|author','Specify the default field used for sorting','Choice'),
('defaultSortOrder','dsc','asc|dsc|az|za','Specify the default sort order','Choice'),
('DefaultToLoggedInLibraryCircRules',  '0', NULL ,  'If enabled, circ rules editor will default to the logged in library''s rules, rather than the ''all libraries'' rules.',  'YesNo'),
('DefaultToLoggedInLibraryNoticesSlips',  '0', NULL ,  'If enabled,slips and notices editor will default to the logged in library''s rules, rather than the ''all libraries'' rules.',  'YesNo'),
('DefaultToLoggedInLibraryOverdueTriggers',  '0', NULL ,  'If enabled, overdue status triggers editor will default to the logged in library''s rules, rather than the ''default'' rules.',  'YesNo'),
('Display856uAsImage','OFF','OFF|Details|Results|Both','Display the URI in the 856u field as an image, the corresponding staff interface XSLT option must be on','Choice'),
('DisplayClearScreenButton','no','no|issueslip|issueqslip','If set to ON, a clear screen button will appear on the circulation page.','Choice'),
('displayFacetCount','0',NULL,NULL,'YesNo'),
('DisplayIconsXSLT','1','','If ON, displays the format, audience, and material type icons in XSLT MARC21 results and detail pages.','YesNo'),
('DisplayLibraryFacets',  'holding',  'home|holding|both',  'Defines which library facets to display.',  'Choice'),
('DisplayMultiPlaceHold','1','','Display the ability to place multiple holds or not','YesNo'),
('DisplayOPACiconsXSLT','1','','If ON, displays the format, audience, and material type icons in XSLT MARC21 results and detail pages in the OPAC.','YesNo'),
('DumpSearchQueryTemplate',0,'','Add the search query being passed to the search engine into the template for debugging','YesNo'),
('DumpTemplateVarsIntranet',  '0', NULL ,  'If enabled, dump all Template Toolkit variable to a comment in the html source for the staff intranet.',  'YesNo'),
('DumpTemplateVarsOpac',  '0', NULL ,  'If enabled, dump all Template Toolkit variable to a comment in the html source for the opac.',  'YesNo'),
('EasyAnalyticalRecords','0','','If on, display in the catalogue screens tools to easily setup analytical record relationships','YesNo'),
('EDIFACT','0',NULL,'Enables EDIFACT acquisitions functions','YesNo'),
('EdifactInvoiceImport', 'automatic', 'automatic|manual', "If on, don't auto-import EDI invoices, just keep them in the database with the status 'new'", 'Choice'),
('EdifactLSQ', 'location', 'location|ccode', 'Map EDI sequence code (GIR+LSQ) to Koha Item field', 'Choice'),
('ElasticsearchCrossFields', '1', '', 'Enable "cross_fields" option for searches using Elastic search.', 'YesNo'),
('ElasticsearchIndexStatus_authorities', '0', 'Authorities index status', NULL, NULL),
('ElasticsearchIndexStatus_biblios', '0', 'Biblios index status', NULL, NULL),
('ElasticsearchMARCFormat', 'ISO2709', 'ISO2709|ARRAY', 'Elasticsearch MARC format. ISO2709 format is recommended as it is faster and takes less space, whereas array is searchable.', 'Choice'),
('EmailAddressForPatronRegistrations', '', '', ' If you choose EmailAddressForPatronRegistrations you have to enter a valid email address: ', 'free'),
('EmailAddressForSuggestions','','',' If you choose EmailAddressForSuggestions you have to enter a valid email address: ','free'),
('EmailFieldPrecedence','email|emailpro|B_email','','Ordered list of patron email fields to use when AutoEmailPrimaryAddress is set to first valid','multiple'),
('EmailFieldPrimary','OFF','email|emailpro|B_email|cardnumber|OFF','Defines the default email address field where patron email notices are sent.','Choice'),
('emailLibrarianWhenHoldIsPlaced','0',NULL,'If ON, emails the librarian whenever a hold is placed','YesNo'),
('EmailOverduesNoEmail','1',NULL,'Send send overdues of patrons without email address to staff','YesNo'),
('EmailPatronRegistrations', '0', '0|EmailAddressForPatronRegistrations|BranchEmailAddress|KohaAdminEmailAddress', 'Choose email address that new patron registrations will be sent to: ', 'Choice'),
('EmailPatronWhenHoldIsPlaced', '0', NULL, 'Email patron when a hold has been placed for them', 'YesNo'),
('EmailPurchaseSuggestions','0','0|EmailAddressForSuggestions|BranchEmailAddress|KohaAdminEmailAddress','Choose email address that new purchase suggestions will be sent to: ','Choice'),
('EmailSMSSendDriverFromAddress', '', '', 'Email SMS send driver from address override', 'Free'),
('EnableAdvancedCatalogingEditor','0','','Enable the Rancor advanced cataloging editor','YesNo'),
('EnableBorrowerFiles','0',NULL,'If enabled, allows librarians to upload and attach arbitrary files to a borrower record.','YesNo'),
('EnableExpiredPasswordReset', '0', NULL, 'Enable ability for patrons with expired password to reset their password directly', 'YesNo'),
('EnableItemGroupHolds','0','','Enable item groups holds feature','YesNo'),
('EnableItemGroups','0','','Enable the item groups feature','YesNo'),
('EnableOpacSearchHistory','1','YesNo','Enable or disable opac search history',''),
('EnablePointOfSale','0',NULL,'Enable the point of sale feature to allow anonymous transactions with the accounting system. (Requires UseCashRegisters)','YesNo'),
('EnableSearchHistory','0','','Enable or disable search history','YesNo'),
('EnhancedMessagingPreferences','1','','If ON, allows patrons to select to receive additional messages about items due or nearly due.','YesNo'),
('EnhancedMessagingPreferencesOPAC', '1', NULL, 'If ON, show patrons messaging setting on the OPAC.', 'YesNo'),
('ERMModule', '0', NULL, 'Enable the e-resource management module', 'YesNo'),
('ERMProviderEbscoApiKey', '', '', 'API key for EBSCO', 'free'),
('ERMProviderEbscoCustomerID', '', '', 'Customer ID for EBSCO', 'free'),
('ERMProviders', 'local', 'local|ebsco', 'Set the providers for the ERM module', 'Choice'),
('ESPreventAutoTruncate', 'barcode|control-number|control-number-identifier|date-of-acquisition|date-of-publication|date-time-last-modified|identifier-standard|isbn|issn|itype|lc-card-number|number-local-acquisition|other-control-number|record-control-number', NULL, 'List of searchfields (separated by | or ,) that should not be autotruncated by Elasticsearch even if QueryAutoTruncate is set to Yes', 'free'),
('ExcludeHolidaysFromMaxPickUpDelay', '0', NULL, 'If ON, reserves max pickup delay takes into accountthe closed days.', 'YesNo'),
('expandedSearchOption','0',NULL,'If ON, set advanced search to be expanded by default','YesNo'),
('ExpireReservesAutoFill','0',NULL,'Automatically fill the next hold with a automatically canceled expired waiting hold.','YesNo'),
('ExpireReservesAutoFillEmail','', NULL,'Send email notification of hold filled from automatically expired/cancelled hold to this address. If not defined, Koha will fallback to the library reply-to address','Free'),
('ExpireReservesMaxPickUpDelay','0','','Enabling this allows holds to expire automatically if they have not been picked by within the time period specified in ReservesMaxPickUpDelay','YesNo'),
('ExpireReservesMaxPickUpDelayCharge','0',NULL,'If ExpireReservesMaxPickUpDelay is enabled, and this field has a non-zero value, than a borrower whose waiting hold has expired will be charged this amount.','free'),
('ExpireReservesOnHolidays', '1', NULL, 'If false, reserves at a library will not be canceled on days the library is not open.', 'YesNo'),
('ExportCircHistory', 0, NULL, "Display the export circulation options",  'YesNo' ),
('ExportRemoveFields','',NULL,'List of fields for non export in circulation.pl (separated by a space)','Free'),
('ExtendedPatronAttributes','1',NULL,'Use extended patron IDs and attributes','YesNo'),
('FacetLabelTruncationLength','20',NULL,'Specify the facet max length in OPAC','Integer'),
('FacetMaxCount','20',NULL,'Specify the max facet count for each category','Integer'),
('FacetOrder','Alphabetical','Alphabetical|Usage','Specify the order of facets within each category','Choice'),
('FailedLoginAttempts','','','Number of login attempts before lockout the patron account','Integer'),
('FallbackToSMSIfNoEmail', 0, 'Enable|Disable', 'Send messages by SMS if no patron email is defined', 'YesNo'),
('FeeOnChangePatronCategory','1','','If set, when a patron changes to a category with enrolment fee, a fee is charged','YesNo'),
('FilterBeforeOverdueReport','0','','Do not run overdue report until filter selected','YesNo'),
('FineNotifyAtCheckin','0',NULL,'If ON notify librarians of overdue fines on the items they are checking in.','YesNo'),
('FinePaymentAutoPopup','0',NULL,'If enabled, automatically display a print dialog for a payment receipt when making a payment.','YesNo'),
('finesCalendar','noFinesWhenClosed','ignoreCalendar|noFinesWhenClosed','Specify whether to use the Calendar in calculating duedates and fines','Choice'),
('FinesIncludeGracePeriod','1',NULL,'If enabled, fines calculations will include the grace period.','YesNo'),
('FinesLog','1',NULL,'If ON, log fines','YesNo'),
('finesMode','off','off|production','Choose the fines mode, \'off\' (no charges), \'production\' (accrue overdue fines).  Requires accruefines cronjob.','Choice'),
('ForceLibrarySelection','0',NULL,'Force staff to select a library when logging into the staff interface.','YesNo'),
('FRBRizeEditions','0','','If ON, Koha will query one or more ISBN web services for associated ISBNs and display an Editions tab on the details pages','YesNo'),
('GenerateAuthorityField667', 'Machine generated authority record', NULL, 'When BiblioAddsAuthorities and AutoCreateAuthorities are enabled, use this as a default value for the 667$a field of MARC21 records', 'free'),
('GenerateAuthorityField670', 'Work cat.', NULL, 'When BiblioAddsAuthorities and AutoCreateAuthorities are enabled, use this as a default value for the 670$a field of MARC21 records', 'free'),
('GoogleJackets','0',NULL,'if ON, displays jacket covers from Google Books API','YesNo'),
('GoogleOAuth2ClientID', '', NULL, 'Client ID for the web app registered with Google', 'Free'),
('GoogleOAuth2ClientSecret', '', NULL, 'Client Secret for the web app registered with Google', 'Free'),
('GoogleOpenIDConnect', '0', NULL, 'if ON, allows the use of Google OpenID Connect for login', 'YesNo'),
('GoogleOpenIDConnectAutoRegister',   '0',NULL,' Google OpenID Connect logins to auto-register patrons.','YesNo'),
('GoogleOpenIDConnectDefaultBranch',  '','','This branch code will be used to create Google OpenID Connect patrons.','Textarea'),
('GoogleOpenIDConnectDefaultCategory','','','This category code will be used to create Google OpenID Connect patrons.','Textarea'),
('GoogleOpenIDConnectDomain', '', NULL, 'Restrict Google OpenID Connect to this domain (or subdomains of this domain). Leave blank for all Google domains', 'Free'),
('hide_marc','0',NULL,'If ON, disables display of MARC fields, subfield codes & indicators (still shows data)','YesNo'),
('hidelostitems','0','','If ON, disables display of\"lost\" items in OPAC.','YesNo'),
('HidePatronName','0','','If this is switched on, patron\'s cardnumber will be shown instead of their name on the holds and catalog screens','YesNo'),
('HidePersonalPatronDetailOnCirculation', 0, '', 'Hide patrons phone number, email address, street address and city in the circulation page','YesNo'),
('HoldFeeMode','not_always','any_time_is_placed|not_always|any_time_is_collected','Set the hold fee mode','Choice'),
('HoldsAutoFill','0',NULL,'If on, librarian will not be asked if hold should be filled, it will be filled automatically','YesNo'),
('HoldsAutoFillPrintSlip','0',NULL,'If on, hold slip print dialog will be displayed automatically','YesNo'),
('HoldsLog','0',NULL,'If ON, log create/cancel/suspend/resume actions on holds.','YesNo'),
('HoldsNeedProcessingSIP', '0', NULL, 'Require staff to check-in before hold is set to waiting state', 'YesNo' ),
('HoldsQueuePrioritizeBranch','homebranch','holdingbranch|homebranch','Decides if holds queue builder patron home library match to home or holding branch','Choice'),
('HoldsQueueSkipClosed', '0', NULL, 'If enabled, any libraries that are closed when the holds queue is built will be ignored for the purpose of filling holds.', 'YesNo'),
('HoldsSplitQueue','nothing','nothing|branch|itemtype|branch_itemtype','In the staff interface, split the holds view by the given criteria','Choice'),
('HoldsSplitQueueNumbering', 'actual', 'actual|virtual', 'If the holds queue is split, decide if the actual priorities should be displayed', 'Choice'),
('HoldsToPullStartDate','2',NULL,'Set the default start date for the Holds to pull list to this many days ago','Integer'),
('HomeOrHoldingBranch','holdingbranch','holdingbranch|homebranch','Used by Circulation to determine which branch of an item to check with independent branches on, and by search to determine which branch to choose for availability ','Choice'),
('HouseboundModule',0,'','If ON, enable housebound module functionality.','YesNo'),
('HTML5MediaEnabled','not','not|opac|staff|both','Show a tab with a HTML5 media player for files catalogued in field 856','Choice'),
('HTML5MediaExtensions','webm|ogg|ogv|oga|vtt','','Media file extensions','free'),
('HTML5MediaYouTube',0,'Embed|Don\'t embed','YouTube links as videos','YesNo'),
('IdRef','0','','Disable/enable the IdRef webservice from the OPAC detail page.','YesNo'),
('ILLCheckAvailability', 0, '', 'If ON, during the ILL request process third party sources will be checked for current availability', 'YesNo'),
('ILLDefaultStaffEmail', '', NULL, 'Fallback email address for staff ILL notices to be sent to in the absence of a branch address', 'Free'),
('ILLHiddenRequestStatuses', NULL, NULL, 'ILL statuses that are considered finished and should not be displayed in the ILL module', 'multiple'),
('IllLog', 0, '', 'If ON, log information about ILL requests', 'YesNo'),
('ILLModule','0','If ON, enables the interlibrary loans module.','','YesNo'),
('ILLModuleCopyrightClearance','','70|10','Enter text to enable the copyright clearance stage of request creation. Text will be displayed','Textarea'),
('ILLModuleDisclaimerByType','','','YAML defining disclaimer settings for each ILL request type','Textarea'),
('ILLModuleUnmediated','0','','If enabled, try to immediately progress newly placed ILL requests.','YesNo'),
('ILLOpacbackends',NULL,NULL,'ILL backends to enabled for OPAC initiated requests','multiple'),
('ILLPartnerCode','IL','','Patrons from this patron category will be used as partners to place ILL requests with','free'),
('ILLSendStaffNotices', NULL, NULL, 'Send these ILL notices to staff', 'multiple'),
('ILS-DI','0','','Enables ILS-DI services at OPAC.','YesNo'),
('ILS-DI:AuthorizedIPs','','Restricts usage of ILS-DI to some IPs','.','Free'),
('ImageLimit','5','','Limit images stored in the database by the Patron Card image manager to this number.','Integer'),
('IncludeSeeFromInSearches','0','','Include see-from references in searches.','YesNo'),
('IndependentBranches','0',NULL,'If ON, increases security between libraries','YesNo'),
('IndependentBranchesPatronModifications','0', NULL, 'Show only modification request for the logged in branch','YesNo'),
('IndependentBranchesTransfers','0', NULL, 'Allow non-superlibrarians to transfer items between libraries','YesNo'),
('intranet_includes','includes',NULL,'The includes directory you want for specific look of Koha (includes or includes_npl for example)','Free'),
('IntranetAddMastheadLibraryPulldown','0', NULL, 'Add a library select pulldown menu on the staff header search','YesNo'),
('IntranetBiblioDefaultView','normal','normal|marc|isbd|labeled_marc','Choose the default detail view in the staff interface; choose between normal, labeled_marc, marc or isbd','Choice'),
('intranetbookbag','1','','If ON, enables display of Cart feature in the intranet','YesNo'),
('IntranetCatalogSearchPulldown','0', NULL, 'Show a search field pulldown for \"Search the catalog\" boxes','YesNo'),
('IntranetCirculationHomeHTML', '', NULL, 'Show the following HTML in a div on the bottom of the reports home page', 'Free'),
('IntranetCoce','0', NULL, 'If on, enables cover retrieval from the configured Coce server in the staff interface', 'YesNo'),
('intranetcolorstylesheet','','50','Define the color stylesheet to use in the staff interface','free'),
('IntranetFavicon','','','Enter a complete URL to an image to replace the default Koha favicon on the staff interface','free'),
('IntranetmainUserblock','','70|10','Add a block of HTML that will display on the intranet home page','Textarea'),
('IntranetNav','','70|10','Use HTML tabs to add navigational links to the top-hand navigational bar in the staff interface','Textarea'),
('IntranetNumbersPreferPhrase','0',NULL,'Control the use of phr operator in callnumber and standard number staff interface searches','YesNo'),
('intranetreadinghistory','1','','If ON, Checkout history is enabled for all patrons','YesNo'),
('IntranetReadingHistoryHolds', 1, '', 'If ON, Holds history is enabled for all patrons','YesNo'),
('IntranetReportsHomeHTML', '', NULL, 'Show the following HTML in a div on the bottom of the reports home page', 'Free'),
('IntranetSlipPrinterJS','','','Use this JavaScript for printing slips. Define at least function printThenClose(). For use e.g. with Firefox PlugIn jsPrintSetup, see http://jsprintsetup.mozdev.org/','Free'),
('intranetstylesheet','','50','Enter a complete URL to use an alternate layout stylesheet in Intranet','free'),
('IntranetUserCSS','',NULL,'Add CSS to be included in the intranet in an embedded <style> tag.','free'),
('IntranetUserJS','','70|10','Custom javascript for inclusion in Intranet','Textarea'),
('ISBD','#100||{ 100a }{ 100b }{ 100c }{ 100d }{ 110a }{ 110b }{ 110c }{ 110d }{ 110e }{ 110f }{ 110g }{ 130a }{ 130d }{ 130f }{ 130g }{ 130h }{ 130k }{ 130l }{ 130m }{ 130n }{ 130o }{ 130p }{ 130r }{ 130s }{ 130t }|<br/><br/>\r\n#245||{ 245a }{ 245b }{245f }{ 245g }{ 245k }{ 245n }{ 245p }{ 245s }{ 245h }|\r\n#246||{ : 246i }{ 246a }{ 246b }{ 246f }{ 246g }{ 246n }{ 246p }{ 246h }|\r\n#242||{ = 242a }{ 242b }{ 242n }{ 242p }{ 242h }|\r\n#245||{ 245c }|\r\n#242||{ = 242c }|\r\n#250| - |{ 250a }{ 250b }|\r\n#254|, |{ 254a }|\r\n#255|, |{ 255a }{ 255b }{ 255c }{ 255d }{ 255e }{ 255f }{ 255g }|\r\n#256|, |{ 256a }|\r\n#257|, |{ 257a }|\r\n#258|, |{ 258a }{ 258b }|\r\n#260| - |{ 260a }{ 260b }{ 260c }|\r\n#300| - |{ 300a }{ 300b }{ 300c }{ 300d }{ 300e }{ 300f }{ 300g }|\r\n#306| - |{ 306a }|\r\n#307| - |{ 307a }{ 307b }|\r\n#310| - |{ 310a }{ 310b }|\r\n#321| - |{ 321a }{ 321b }|\r\n#340| - |{ 3403 }{ 340a }{ 340b }{ 340c }{ 340d }{ 340e }{ 340f }{ 340h }{ 340i }|\r\n#342| - |{ 342a }{ 342b }{ 342c }{ 342d }{ 342e }{ 342f }{ 342g }{ 342h }{ 342i }{ 342j }{ 342k }{ 342l }{ 342m }{ 342n }{ 342o }{ 342p }{ 342q }{ 342r }{ 342s }{ 342t }{ 342u }{ 342v }{ 342w }|\r\n#343| - |{ 343a }{ 343b }{ 343c }{ 343d }{ 343e }{ 343f }{ 343g }{ 343h }{ 343i }|\r\n#351| - |{ 3513 }{ 351a }{ 351b }{ 351c }|\r\n#352| - |{ 352a }{ 352b }{ 352c }{ 352d }{ 352e }{ 352f }{ 352g }{ 352i }{ 352q }|\r\n#362| - |{ 362a }{ 351z }|\r\n#440| - |{ 440a }{ 440n }{ 440p }{ 440v }{ 440x }|.\r\n#490| - |{ 490a }{ 490v }{ 490x }|.\r\n#800| - |{ 800a }{ 800b }{ 800c }{ 800d }{ 800e }{ 800f }{ 800g }{ 800h }{ 800j }{ 800k }{ 800l }{ 800m }{ 800n }{ 800o }{ 800p }{ 800q }{ 800r }{ 800s }{ 800t }{ 800u }{ 800v }|.\r\n#810| - |{ 810a }{ 810b }{ 810c }{ 810d }{ 810e }{ 810f }{ 810g }{ 810h }{ 810k }{ 810l }{ 810m }{ 810n }{ 810o }{ 810p }{ 810r }{ 810s }{ 810t }{ 810u }{ 810v }|.\r\n#811| - |{ 811a }{ 811c }{ 811d }{ 811e }{ 811f }{ 811g }{ 811h }{ 811k }{ 811l }{ 811n }{ 811p }{ 811q }{ 811s }{ 811t }{ 811u }{ 811v }|.\r\n#830| - |{ 830a }{ 830d }{ 830f }{ 830g }{ 830h }{ 830k }{ 830l }{ 830m }{ 830n }{ 830o }{ 830p }{ 830r }{ 830s }{ 830t }{ 830v }|.\r\n#500|<br/><br/>|{ 5003 }{ 500a }|\r\n#501|<br/><br/>|{ 501a }|\r\n#502|<br/><br/>|{ 502a }|\r\n#504|<br/><br/>|{ 504a }|\r\n#505|<br/><br/>|{ 505a }{ 505t }{ 505r }{ 505g }{ 505u }|\r\n#506|<br/><br/>|{ 5063 }{ 506a }{ 506b }{ 506c }{ 506d }{ 506u }|\r\n#507|<br/><br/>|{ 507a }{ 507b }|\r\n#508|<br/><br/>|{ 508a }{ 508a }|\r\n#510|<br/><br/>|{ 5103 }{ 510a }{ 510x }{ 510c }{ 510b }|\r\n#511|<br/><br/>|{ 511a }|\r\n#513|<br/><br/>|{ 513a }{513b }|\r\n#514|<br/><br/>|{ 514z }{ 514a }{ 514b }{ 514c }{ 514d }{ 514e }{ 514f }{ 514g }{ 514h }{ 514i }{ 514j }{ 514k }{ 514m }{ 514u }|\r\n#515|<br/><br/>|{ 515a }|\r\n#516|<br/><br/>|{ 516a }|\r\n#518|<br/><br/>|{ 5183 }{ 518a }|\r\n#520|<br/><br/>|{ 5203 }{ 520a }{ 520b }{ 520u }|\r\n#521|<br/><br/>|{ 5213 }{ 521a }{ 521b }|\r\n#522|<br/><br/>|{ 522a }|\r\n#524|<br/><br/>|{ 524a }|\r\n#525|<br/><br/>|{ 525a }|\r\n#526|<br/><br/>|{\\n510i }{\\n510a }{ 510b }{ 510c }{ 510d }{\\n510x }|\r\n#530|<br/><br/>|{\\n5063 }{\\n506a }{ 506b }{ 506c }{ 506d }{\\n506u }|\r\n#533|<br/><br/>|{\\n5333 }{\\n533a }{\\n533b }{\\n533c }{\\n533d }{\\n533e }{\\n533f }{\\n533m }{\\n533n }|\r\n#534|<br/><br/>|{\\n533p }{\\n533a }{\\n533b }{\\n533c }{\\n533d }{\\n533e }{\\n533f }{\\n533m }{\\n533n }{\\n533t }{\\n533x }{\\n533z }|\r\n#535|<br/><br/>|{\\n5353 }{\\n535a }{\\n535b }{\\n535c }{\\n535d }|\r\n#538|<br/><br/>|{\\n5383 }{\\n538a }{\\n538i }{\\n538u }|\r\n#540|<br/><br/>|{\\n5403 }{\\n540a }{ 540b }{ 540c }{ 540d }{\\n520u }|\r\n#544|<br/><br/>|{\\n5443 }{\\n544a }{\\n544b }{\\n544c }{\\n544d }{\\n544e }{\\n544n }|\r\n#545|<br/><br/>|{\\n545a }{ 545b }{\\n545u }|\r\n#546|<br/><br/>|{\\n5463 }{\\n546a }{ 546b }|\r\n#547|<br/><br/>|{\\n547a }|\r\n#550|<br/><br/>|{ 550a }|\r\n#552|<br/><br/>|{ 552z }{ 552a }{ 552b }{ 552c }{ 552d }{ 552e }{ 552f }{ 552g }{ 552h }{ 552i }{ 552j }{ 552k }{ 552l }{ 552m }{ 552n }{ 562o }{ 552p }{ 552u }|\r\n#555|<br/><br/>|{ 5553 }{ 555a }{ 555b }{ 555c }{ 555d }{ 555u }|\r\n#556|<br/><br/>|{ 556a }{ 506z }|\r\n#563|<br/><br/>|{ 5633 }{ 563a }{ 563u }|\r\n#565|<br/><br/>|{ 5653 }{ 565a }{ 565b }{ 565c }{ 565d }{ 565e }|\r\n#567|<br/><br/>|{ 567a }|\r\n#580|<br/><br/>|{ 580a }|\r\n#581|<br/><br/>|{ 5633 }{ 581a }{ 581z }|\r\n#584|<br/><br/>|{ 5843 }{ 584a }{ 584b }|\r\n#585|<br/><br/>|{ 5853 }{ 585a }|\r\n#586|<br/><br/>|{ 5863 }{ 586a }|\r\n#020|<br/><br/><label>ISBN: </label>|{ 020a }{ 020c }|\r\n#022|<br/><br/><label>ISSN: </label>|{ 022a }|\r\n#222| = |{ 222a }{ 222b }|\r\n#210| = |{ 210a }{ 210b }|\r\n#024|<br/><br/><label>Standard No.: </label>|{ 024a }{ 024c }{ 024d }{ 0242 }|\r\n#027|<br/><br/><label>Standard Tech. Report. No.: </label>|{ 027a }|\r\n#028|<br/><br/><label>Publisher. No.: </label>|{ 028a }{ 028b }|\r\n#013|<br/><br/><label>Patent No.: </label>|{ 013a }{ 013b }{ 013c }{ 013d }{ 013e }{ 013f }|\r\n#030|<br/><br/><label>CODEN: </label>|{ 030a }|\r\n#037|<br/><br/><label>Source: </label>|{ 037a }{ 037b }{ 037c }{ 037f }{ 037g }{ 037n }|\r\n#010|<br/><br/><label>LCCN: </label>|{ 010a }|\r\n#015|<br/><br/><label>Nat. Bib. No.: </label>|{ 015a }{ 0152 }|\r\n#016|<br/><br/><label>Nat. Bib. Agency Control No.: </label>|{ 016a }{ 0162 }|\r\n#600|<br/><br/><label>Subjects--Personal Names: </label>|{\\n6003 }{\\n600a}{ 600b }{ 600c }{ 600d }{ 600e }{ 600f }{ 600g }{ 600h }{--600k}{ 600l }{ 600m }{ 600n }{ 600o }{--600p}{ 600r }{ 600s }{ 600t }{ 600u }{--600x}{--600z}{--600y}{--600v}|\r\n#610|<br/><br/><label>Subjects--Corporate Names: </label>|{\\n6103 }{\\n610a}{ 610b }{ 610c }{ 610d }{ 610e }{ 610f }{ 610g }{ 610h }{--610k}{ 610l }{ 610m }{ 610n }{ 610o }{--610p}{ 610r }{ 610s }{ 610t }{ 610u }{--610x}{--610z}{--610y}{--610v}|\r\n#611|<br/><br/><label>Subjects--Meeting Names: </label>|{\\n6113 }{\\n611a}{ 611b }{ 611c }{ 611d }{ 611e }{ 611f }{ 611g }{ 611h }{--611k}{ 611l }{ 611m }{ 611n }{ 611o }{--611p}{ 611r }{ 611s }{ 611t }{ 611u }{--611x}{--611z}{--611y}{--611v}|\r\n#630|<br/><br/><label>Subjects--Uniform Titles: </label>|{\\n630a}{ 630b }{ 630c }{ 630d }{ 630e }{ 630f }{ 630g }{ 630h }{--630k }{ 630l }{ 630m }{ 630n }{ 630o }{--630p}{ 630r }{ 630s }{ 630t }{--630x}{--630z}{--630y}{--630v}|\r\n#648|<br/><br/><label>Subjects--Chronological Terms: </label>|{\\n6483 }{\\n648a }{--648x}{--648z}{--648y}{--648v}|\r\n#650|<br/><br/><label>Subjects--Topical Terms: </label>|{\\n6503 }{\\n650a}{ 650b }{ 650c }{ 650d }{ 650e }{--650x}{--650z}{--650y}{--650v}|\r\n#651|<br/><br/><label>Subjects--Geographic Terms: </label>|{\\n6513 }{\\n651a}{ 651b }{ 651c }{ 651d }{ 651e }{--651x}{--651z}{--651y}{--651v}|\r\n#653|<br/><br/><label>Subjects--Index Terms: </label>|{ 653a }|\r\n#654|<br/><br/><label>Subjects--Facted Index Terms: </label>|{\\n6543 }{\\n654a}{--654b}{--654x}{--654z}{--654y}{--654v}|\r\n#655|<br/><br/><label>Index Terms--Genre/Form: </label>|{\\n6553 }{\\n655a}{--655b}{--655x }{--655z}{--655y}{--655v}|\r\n#656|<br/><br/><label>Index Terms--Occupation: </label>|{\\n6563 }{\\n656a}{--656k}{--656x}{--656z}{--656y}{--656v}|\r\n#657|<br/><br/><label>Index Terms--Function: </label>|{\\n6573 }{\\n657a}{--657x}{--657z}{--657y}{--657v}|\r\n#658|<br/><br/><label>Index Terms--Curriculum Objective: </label>|{\\n658a}{--658b}{--658c}{--658d}{--658v}|\r\n#050|<br/><br/><label>LC Class. No.: </label>|{ 050a }{ / 050b }|\r\n#082|<br/><br/><label>Dewey Class. No.: </label>|{ 082a }{ / 082b }|\r\n#080|<br/><br/><label>Universal Decimal Class. No.: </label>|{ 080a }{ 080x }{ / 080b }|\r\n#070|<br/><br/><label>National Agricultural Library Call No.: </label>|{ 070a }{ / 070b }|\r\n#060|<br/><br/><label>National Library of Medicine Call No.: </label>|{ 060a }{ / 060b }|\r\n#074|<br/><br/><label>GPO Item No.: </label>|{ 074a }|\r\n#086|<br/><br/><label>Gov. Doc. Class. No.: </label>|{ 086a }|\r\n#088|<br/><br/><label>Report. No.: </label>|{ 088a }|','70|10','ISBD','Textarea'),
('IssueLog','1',NULL,'If ON, log checkout activity','YesNo'),
('IssueLostItem','alert','Defines what should be done when an attempt is made to issue an item that has been marked as lost.','alert|confirm|nothing','Choice'),
('IssuingInProcess','0',NULL,'If ON, disables fines if the patron is issuing item that accumulate debt','YesNo'),
('item-level_itypes','1','','If ON, enables Item-level Itemtype / Issuing Rules','YesNo'),
('itemBarcodeFallbackSearch','0',NULL,'If set, uses scanned item barcodes as a catalogue search if not found as barcodes','YesNo'),
('itemBarcodeInputFilter','','whitespace|T-prefix|cuecat|libsuite8|EAN13','If set, allows specification of a item barcode input filter','Choice'),
('itemcallnumber','',NULL,'The MARC field/subfield that is used to calculate the itemcallnumber (Dewey would be 082ab or 092ab; LOC would be 050ab or 090ab) could be 852hi from an item record','free'),
('ItemsDeniedRenewal','','','This syspref allows to define custom rules for denying renewal of specific items.','Textarea'),
('KohaAdminEmailAddress','root@localhost','','Define the email address where patron modification requests are sent','free'),
('KohaManualBaseURL','https://koha-community.org/manual/','','Where is the Koha manual/documentation located?','Free'),
('KohaManualLanguage','en','en|ar|cs|de|es|fr|it|pt_BR|tr|zh_TW','What is the language of the online manual you want to use?','Choice'),
('LabelMARCView','standard','standard|economical','Define how a MARC record will display','Choice'),
('language','en',NULL,'Set the default language in the staff interface.','Languages'),
('LibraryName','','','Define the library name as displayed on the OPAC',''),
('LibraryThingForLibrariesEnabled','0','','Enable or Disable Library Thing for Libraries Features','YesNo'),
('LibraryThingForLibrariesID','','','See:http://librarything.com/forlibraries/','free'),
('LibraryThingForLibrariesTabbedView','0','','Put LibraryThingForLibraries Content in Tabs.','YesNo'),
('LibrisKey', '', 'This key must be obtained at http://api.libris.kb.se/. It is unique for the IP of the server.', NULL, 'Free'),
('LibrisURL', 'http://api.libris.kb.se/bibspell/', 'This it the base URL for the Libris spellchecking API.',NULL,'Free'),
('LinkerConsiderThesaurus','0',NULL,'If ON the authority linker will only search for 6XX authorities from the same source as the heading','YesNo'),
('LinkerKeepStale','0',NULL,'If ON the authority linker will keep existing authority links for headings where it is unable to find a match.','YesNo'),
('LinkerModule','Default','Default|FirstMatch|LastMatch','Chooses which linker module to use (see documentation).','Choice'),
('LinkerOptions','','','A pipe-separated list of options for the linker.','free'),
('LinkerRelink','1',NULL,'If ON the authority linker will relink headings that have previously been linked every time it runs.','YesNo'),
('ListOwnerDesignated', NULL, NULL, 'Designated list owner at patron deletion', 'Free'),
('ListOwnershipUponPatronDeletion', 'delete', 'delete|transfer', 'Defines the action on their public or shared lists when patron is deleted', 'Choice'),
('LoadCheckoutsTableDelay','0','','Delay before auto-loading checkouts table on checkouts screen','Integer'),
('LoadSearchHistoryToTheFirstLoggedUser', '1', NULL, 'If ON, the next user will automatically get the last searches in their history', 'YesNo'),
('LocalCoverImages','0','1','Display local cover images on intranet details pages.','YesNo'),
('LocalHoldsPriority',  '0', NULL,  'Enables the LocalHoldsPriority feature',  'YesNo'),
('LocalHoldsPriorityItemControl',  'holdingbranch',  'holdingbranch|homebranch',  'decides if the feature operates using the item''s home or holding library.',  'Choice'),
('LocalHoldsPriorityPatronControl',  'PickupLibrary',  'HomeLibrary|PickupLibrary',  'decides if the feature operates using the library set as the patron''s home library, or the library set as the pickup library for the given hold.',  'Choice'),
('LockExpiredDelay','','','Delay for locking expired patrons (empty means no locking)','Integer'),
('makePreviousSerialAvailable','0','','make previous serial automatically available when collecting a new serial. Please note that the item-level_itypes syspref must be set to specific item.','YesNo'),
('Mana','2',NULL,'request to Mana Webservice. Mana centralize common information between other Koha to facilitate the creation of new subscriptions, vendors, report queries etc... You can search, share, import and comment the content of Mana.','Choice'),
('ManaToken','',NULL,'Security token used for authentication on Mana KB service (anti spam)','Textarea'),
('MARCAuthorityControlField008','|| aca||aabn           | a|a     d',NULL,'Define the contents of MARC21 authority control field 008 position 06-39','Textarea'),
('MarcFieldDocURL', NULL, NULL, 'URL used for MARC field documentation. Following substitutions are available: {MARC} = marc flavour, eg. "MARC21" or "UNIMARC". {FIELD} = field number, eg. "000" or "048". {LANG} = user language, eg. "en" or "fi-FI"', 'free'),
('MarcFieldForCreatorId','',NULL,'Where to store the borrowernumber of the record''s creator','Free'),
('MarcFieldForCreatorName','',NULL,'Where to store the name of the record''s creator','Free'),
('MarcFieldForModifierId','',NULL,'Where to store the borrowernumber of the record''s last modifier','Free'),
('MarcFieldForModifierName','',NULL,'Where to store the name of the record''s last modifier','Free'),
('MarcFieldsToOrder','',NULL,'Set the mapping values for a new order line created from a MARC record in a staged file. In a YAML format.','textarea'),
('MarcItemFieldsToOrder','',NULL,'Set the mapping values for new item records created from a MARC record in a staged file. In a YAML format.','textarea'),
('MARCOrgCode','OSt','','Define MARC Organization Code for MARC21 records - http://www.loc.gov/marc/organizations/orgshome.html','free'),
('MARCOverlayRules','0',NULL,'Use the MARC record overlay rules system to decide what actions to take for each field when modifying records.','YesNo'),
('MarkLostItemsAsReturned','batchmod,moredetail,cronjob,additem,pendingreserves,onpayment','claim_returned|batchmod|moredetail|cronjob|additem|pendingreserves|onpayment','Mark items as returned when flagged as lost','multiple'),
('MaxComponentRecords', '300', '','Max number of component records to display','Integer'),
('MaxFine',NULL,'','Maximum fine a patron can have for all late returns at one moment. Single item caps are specified in the circulation rules matrix.','Integer'),
('maxItemsInSearchResults','20',NULL,'Specify the maximum number of items to display for each result on a page of results','free'),
('MaxItemsToDisplayForBatchDel','1000',NULL,'Display up to a given number of items in a single item deletionbatch.','Integer'),
('MaxItemsToDisplayForBatchMod','1000',NULL,'Display up to a given number of items in a single item modification batch.','Integer'),
('MaxItemsToProcessForBatchMod','1000',NULL,'Process up to a given number of items in a single item modification batch.','Integer'),
('MaxOpenSuggestions','',NULL,'Limit the number of open suggestions a patron can have at once','Integer'),
('maxoutstanding','5','','maximum amount withstanding to be able make holds','Integer'),
('maxRecordsForFacets','20',NULL,NULL,'Integer'),
('maxreserves','50','','Define maximum number of holds a patron can place','Integer'),
('MaxSearchResultsItemsPerRecordStatusCheck','20','','Max number of items per record for which to check transit and hold status','Integer'),
('MaxTotalSuggestions','',NULL,'Number of total suggestions used for time limit with NumberOfSuggestionDays','Free'),
('MembershipExpiryDaysNotice','',NULL,'Send an account expiration notice that a patron\'s card is about to expire after','Integer'),
('MergeReportFields','',NULL,'Displayed fields for deleted MARC records after merge','Free'),
('minPasswordLength','8',NULL,'Specify the minimum length of a patron/staff password','free'),
('NewItemsDefaultLocation','','','If set, all new items will have a location of the given Location Code ( Authorized Value type LOC )',''),
('NewsAuthorDisplay','none','none|opac|staff|both','Display the author name for news items.','Choice'),
('NewsLog','0',NULL,'If ON, log OPAC news changes','YesNo'),
('noissuescharge','5','','Define maximum amount withstanding before checkouts are blocked','Integer'),
('NoIssuesChargeGuarantees','','','Define maximum amount withstanding before checkouts are blocked','Integer'),
('NoIssuesChargeGuarantorsWithGuarantees','','','Define maximum amount withstanding before checkouts are blocked including guarantors and their other guarantees','Integer'),
('noItemTypeImages','0',NULL,'If ON, disables itemtype images in the staff interface','YesNo'),
('NoRefundOnLostReturnedItemsAge','','','Do not refund lost item fees if item is lost for more than this number of days','Integer'),
('NoRenewalBeforePrecision','exact_time','date|exact_time','Calculate "No renewal before" based on date only or exact time of due date','Choice'),
('NotesToHide','',NULL,'List of notes fields that should not appear in the title notes/description separator of details','free'),
('NotHighlightedWords','and|or|not',NULL,'List of words to NOT highlight when OpacHitHighlight is enabled','free'),
('NoticeBcc','','','Email address to bcc outgoing notices sent by email','free'),
('NoticeCSS','',NULL,'Notices CSS url.','free'),
('NoticesLog','0',NULL,'If enabled, log changes to notice templates','YesNo'),
('NotifyBorrowerDeparture','30',NULL,'Define number of days before expiry where circulation is warned about patron account expiry','Integer'),
('NotifyPasswordChange','1',NULL,'Notify patrons whenever their password is changed.','YesNo'),
('NovelistSelectEnabled','0',NULL,'Enable Novelist Select content.  Requires Novelist Profile and Password','YesNo'),
('NovelistSelectPassword','',NULL,'Novelist select user Password','free'),
('NovelistSelectProfile','',NULL,'Novelist Select user Profile','free'),
('NovelistSelectStaffEnabled','0',NULL,'Enable Novelist Select content in the staff interface.  Requires Novelist Profile and Password','YesNo'),
('NovelistSelectStaffProfile','',NULL,'Novelist Select user Profile for staff interface','free'),
('NovelistSelectStaffView','tab','tab|above|below','Where to display Novelist Select content in the staff interface','Choice'),
('NovelistSelectView','tab','tab|above|below|right','Where to display Novelist Select content','Choice'),
('NumberOfSuggestionDays','',NULL,'Number of days that will be used to determine the MaxTotalSuggestions limit','Free'),
('numReturnedItemsToShow','20',NULL,'Number of returned items to show on the check-in page','Integer'),
('numSearchResults','20',NULL,'Specify the maximum number of results to display on a page of results','Integer'),
('numSearchResultsDropdown', 0, NULL, 'Enable option list of number of results per page to show in staff interface search results','YesNo'),
('numSearchRSSResults','50',NULL,'Specify the maximum number of results to display on a RSS page of results','Integer'),
('OAI-PMH','0',NULL,'if ON, OAI-PMH server is enabled','YesNo'),
('OAI-PMH:archiveID','KOHA-OAI-TEST',NULL,'OAI-PMH archive identification','Free'),
('OAI-PMH:AutoUpdateSets','0','','Automatically update OAI sets when a bibliographic or item record is created or updated','YesNo'),
('OAI-PMH:AutoUpdateSetsEmbedItemData', '0', '', 'Embed item information when automatically updating OAI sets. Requires OAI-PMH:AutoUpdateSets syspref to be enabled', 'YesNo'),
('OAI-PMH:ConfFile','',NULL,'If empty, Koha OAI Server operates in normal mode, otherwise it operates in extended mode.','File'),
('OAI-PMH:DeletedRecord','persistent','Koha\'s deletedbiblio table will never be deleted (persistent), might be deleted (transient), or will never have any data in it (no)','transient|persistent|no','Choice'),
('OAI-PMH:MaxCount','50',NULL,'OAI-PMH maximum number of records by answer to ListRecords and ListIdentifiers queries','Integer'),
('OnSiteCheckoutAutoCheck','0','','Enable/Do not enable onsite checkout by default if last checkout was an onsite checkout','YesNo'),
('OnSiteCheckouts','0','','Enable/Disable the on-site checkouts feature','YesNo'),
('OnSiteCheckoutsForce','0','','Enable/Disable the on-site for all cases (Even if a user is debarred, etc.)','YesNo'),
('OPACAcquisitionDetails','0','','Show the acquisition details at the OPAC','YesNo'),
('OpacAdditionalStylesheet','','','Define an auxiliary stylesheet for OPAC use, to override specified settings from the primary opac.css stylesheet. Enter the filename (if the file is in the server\'s css directory) or a complete URL beginning with http (if the file lives on a remote server).','free'),
('OpacAddMastheadLibraryPulldown','0','','Adds a pulldown menu to select the library to search on the opac masthead.','YesNo'),
('OpacAdvancedSearchTypes','itemtypes','itemtypes|ccode','Select which set of fields are available as limits on the OPAC advanced search page','Choice'),
('OpacAdvSearchMoreOptions','pubdate,itemtype,language,subtype,sorting,location','Show search options for the expanded view (More options)','pubdate|itemtype|language|subtype|sorting|location','multiple'),
('OpacAdvSearchOptions','pubdate,itemtype,language,sorting,location','Show search options','pubdate|itemtype|language|subtype|sorting|location','multiple'),
('OPACAllowHoldDateInFuture','0','','If set, along with the AllowHoldDateInFuture system preference, OPAC users can set the date of a hold to be in the future.','YesNo'),
('OpacAllowPublicListCreation','1',NULL,'If set, allows opac users to create public lists','YesNo'),
('OpacAllowSharingPrivateLists','0',NULL,'If set, allows opac users to share private lists with other patrons','YesNo'),
('OPACAllowUserToChangeBranch','','Pending, In-Transit, Suspended','Allow users to change the library to pick up a hold for these statuses:','multiple'),
('OPACAllowUserToChooseBranch','1','1','Allow the user to choose the branch they want to pickup their hold from','YesNo'),
('OPACAmazonCoverImages','0','','Display cover images on OPAC from Amazon Web Services','YesNo'),
('OPACAuthorIdentifiers','0','','Display author identifiers on the OPAC detail page','YesNo'),
('OpacAuthorities','1',NULL,'If ON, enables the search authorities link on OPAC','YesNo'),
('OPACBaseURL','',NULL,'Specify the Base URL of the OPAC, e.g., http://opac.mylibrary.com, including the protocol (http:// or https://). Otherwise, the http:// will be added automatically by Koha upon saving.','Free'),
('opacbookbag','1','','If ON, enables display of Cart feature','YesNo'),
('OpacBrowser','0',NULL,'If ON, enables subject authorities browser on OPAC (needs to set misc/cronjob/sbuild_browser_and_cloud.pl)','YesNo'),
('OpacBrowseResults','1',NULL,'Disable/enable browsing and paging search results from the OPAC detail page.','YesNo'),
('OpacBrowseSearch', '0',NULL, "Elasticsearch only: add a page allowing users to 'browse' all items in the collection",'YesNo'),
('OpacCatalogConcerns', '0', NULL, 'Allow logged in OPAC users to report catalog concerns', 'YesNo'),
('OpacCloud','0',NULL,'If ON, enables subject cloud on OPAC','YesNo'),
('OpacCoce','0', NULL, 'If on, enables cover retrieval from the configured Coce server in the OPAC', 'YesNo'),
('OPACComments','1','','If ON, enables patron reviews of bibliographic records in the OPAC','YesNo'),
('OPACCustomCoverImages','0',NULL,'If enabled, the custom cover images will be displayed at the OPAC. CustomCoverImagesURL must be defined.','YesNo'),
('OPACdefaultSortField','relevance','relevance|popularity|call_number|pubdate|acqdate|title|author','Specify the default field used for sorting','Choice'),
('OPACdefaultSortOrder','dsc','asc|dsc|za|az','Specify the default sort order','Choice'),
('OPACDetailQRCode','0','','Enable the display of a QR Code on the OPAC detail page','YesNo'),
('OPACdidyoumean','',NULL,'Did you mean? configuration for the OPAC. Do not change, as this is controlled by /cgi-bin/koha/admin/didyoumean.pl.','Free'),
('OPACDisplay856uAsImage','OFF','OFF|Details|Results|Both','Display the URI in the 856u field as an image, the corresponding OPACXSLT option must be on','Choice'),
('OpacExportOptions','bibtex,dc,marcxml,marc8,utf8,marcstd,mods,ris,isbd','','Define export options available on OPAC detail page.','multiple'),
('OPACFallback', 'prog', 'bootstrap|prog', 'Define the fallback theme for the OPAC interface.', 'Themes'),
('OpacFavicon','','','Enter a complete URL to an image to replace the default Koha favicon on the OPAC','free'),
('OPACFineNoRenewals','100','','Fine limit above which user cannot renew books via OPAC','Integer'),
('OPACFineNoRenewalsBlockAutoRenew','0','','Block/Allow auto renewals if the patron owe more than OPACFineNoRenewals','YesNo'),
('OPACFineNoRenewalsIncludeCredits','1',NULL,'If enabled the value specified in OPACFineNoRenewals should include any unapplied account credits in the calculation','YesNo'),
('OPACFinesTab','1','','If OFF the patron fines tab in the OPAC is disabled.','YesNo'),
('OPACFRBRizeEditions','0','','If ON, the OPAC will query one or more ISBN web services for associated ISBNs and display an Editions tab on the details pages','YesNo'),
('OpacHiddenItems','','','This syspref allows to define custom rules for hiding specific items at the OPAC. See http://wiki.koha-community.org/wiki/OpacHiddenItems for more information.','Textarea'),
('OpacHiddenItemsExceptions','',NULL,'List of borrower categories, separated by comma, that can see items otherwise hidden by OpacHiddenItems','Textarea'),
('OpacHiddenItemsHidesRecord','1','','Hide biblio record when all its items are hidden because of OpacHiddenItems','YesNo'),
('OpacHighlightedWords','1','','If Set, then queried words are higlighted in OPAC','YesNo'),
('OPACHoldingsDefaultSortField','first_column','first_column|homebranch|holdingbranch','Default sort field for the holdings table at the OPAC','choice'),
('OpacHoldNotes','0','','Show hold notes on OPAC','YesNo'),
('OPACHoldRequests','1',NULL,'If ON, globally enables patron holds on OPAC','YesNo'),
('OPACHoldsHistory','0','','If ON, enables display of Patron Holds History in OPAC','YesNo'),
('OPACHoldsIfAvailableAtPickup','1','','Allow patrons to place a hold at pickup locations (libraries) where the item is available','YesNo'),
('OPACHoldsIfAvailableAtPickupExceptions','','','List the patron categories not affected by OPACHoldsIfAvailableAtPickup if off','Free'),
('OPACISBD','#100||{ 100a }{ 100b }{ 100c }{ 100d }{ 110a }{ 110b }{ 110c }{ 110d }{ 110e }{ 110f }{ 110g }{ 130a }{ 130d }{ 130f }{ 130g }{ 130h }{ 130k }{ 130l }{ 130m }{ 130n }{ 130o }{ 130p }{ 130r }{ 130s }{ 130t }|<br/><br/>\r\n#245||{ 245a }{ 245b }{245f }{ 245g }{ 245k }{ 245n }{ 245p }{ 245s }{ 245h }|\r\n#246||{ : 246i }{ 246a }{ 246b }{ 246f }{ 246g }{ 246n }{ 246p }{ 246h }|\r\n#242||{ = 242a }{ 242b }{ 242n }{ 242p }{ 242h }|\r\n#245||{ 245c }|\r\n#242||{ = 242c }|\r\n#250| - |{ 250a }{ 250b }|\r\n#254|, |{ 254a }|\r\n#255|, |{ 255a }{ 255b }{ 255c }{ 255d }{ 255e }{ 255f }{ 255g }|\r\n#256|, |{ 256a }|\r\n#257|, |{ 257a }|\r\n#258|, |{ 258a }{ 258b }|\r\n#260| - |{ 260a }{ 260b }{ 260c }|\r\n#300| - |{ 300a }{ 300b }{ 300c }{ 300d }{ 300e }{ 300f }{ 300g }|\r\n#306| - |{ 306a }|\r\n#307| - |{ 307a }{ 307b }|\r\n#310| - |{ 310a }{ 310b }|\r\n#321| - |{ 321a }{ 321b }|\r\n#340| - |{ 3403 }{ 340a }{ 340b }{ 340c }{ 340d }{ 340e }{ 340f }{ 340h }{ 340i }|\r\n#342| - |{ 342a }{ 342b }{ 342c }{ 342d }{ 342e }{ 342f }{ 342g }{ 342h }{ 342i }{ 342j }{ 342k }{ 342l }{ 342m }{ 342n }{ 342o }{ 342p }{ 342q }{ 342r }{ 342s }{ 342t }{ 342u }{ 342v }{ 342w }|\r\n#343| - |{ 343a }{ 343b }{ 343c }{ 343d }{ 343e }{ 343f }{ 343g }{ 343h }{ 343i }|\r\n#351| - |{ 3513 }{ 351a }{ 351b }{ 351c }|\r\n#352| - |{ 352a }{ 352b }{ 352c }{ 352d }{ 352e }{ 352f }{ 352g }{ 352i }{ 352q }|\r\n#362| - |{ 362a }{ 351z }|\r\n#440| - |{ 440a }{ 440n }{ 440p }{ 440v }{ 440x }|.\r\n#490| - |{ 490a }{ 490v }{ 490x }|.\r\n#800| - |{ 800a }{ 800b }{ 800c }{ 800d }{ 800e }{ 800f }{ 800g }{ 800h }{ 800j }{ 800k }{ 800l }{ 800m }{ 800n }{ 800o }{ 800p }{ 800q }{ 800r }{ 800s }{ 800t }{ 800u }{ 800v }|.\r\n#810| - |{ 810a }{ 810b }{ 810c }{ 810d }{ 810e }{ 810f }{ 810g }{ 810h }{ 810k }{ 810l }{ 810m }{ 810n }{ 810o }{ 810p }{ 810r }{ 810s }{ 810t }{ 810u }{ 810v }|.\r\n#811| - |{ 811a }{ 811c }{ 811d }{ 811e }{ 811f }{ 811g }{ 811h }{ 811k }{ 811l }{ 811n }{ 811p }{ 811q }{ 811s }{ 811t }{ 811u }{ 811v }|.\r\n#830| - |{ 830a }{ 830d }{ 830f }{ 830g }{ 830h }{ 830k }{ 830l }{ 830m }{ 830n }{ 830o }{ 830p }{ 830r }{ 830s }{ 830t }{ 830v }|.\r\n#500|<br/><br/>|{ 5003 }{ 500a }|\r\n#501|<br/><br/>|{ 501a }|\r\n#502|<br/><br/>|{ 502a }|\r\n#504|<br/><br/>|{ 504a }|\r\n#505|<br/><br/>|{ 505a }{ 505t }{ 505r }{ 505g }{ 505u }|\r\n#506|<br/><br/>|{ 5063 }{ 506a }{ 506b }{ 506c }{ 506d }{ 506u }|\r\n#507|<br/><br/>|{ 507a }{ 507b }|\r\n#508|<br/><br/>|{ 508a }{ 508a }|\r\n#510|<br/><br/>|{ 5103 }{ 510a }{ 510x }{ 510c }{ 510b }|\r\n#511|<br/><br/>|{ 511a }|\r\n#513|<br/><br/>|{ 513a }{513b }|\r\n#514|<br/><br/>|{ 514z }{ 514a }{ 514b }{ 514c }{ 514d }{ 514e }{ 514f }{ 514g }{ 514h }{ 514i }{ 514j }{ 514k }{ 514m }{ 514u }|\r\n#515|<br/><br/>|{ 515a }|\r\n#516|<br/><br/>|{ 516a }|\r\n#518|<br/><br/>|{ 5183 }{ 518a }|\r\n#520|<br/><br/>|{ 5203 }{ 520a }{ 520b }{ 520u }|\r\n#521|<br/><br/>|{ 5213 }{ 521a }{ 521b }|\r\n#522|<br/><br/>|{ 522a }|\r\n#524|<br/><br/>|{ 524a }|\r\n#525|<br/><br/>|{ 525a }|\r\n#526|<br/><br/>|{\\n510i }{\\n510a }{ 510b }{ 510c }{ 510d }{\\n510x }|\r\n#530|<br/><br/>|{\\n5063 }{\\n506a }{ 506b }{ 506c }{ 506d }{\\n506u }|\r\n#533|<br/><br/>|{\\n5333 }{\\n533a }{\\n533b }{\\n533c }{\\n533d }{\\n533e }{\\n533f }{\\n533m }{\\n533n }|\r\n#534|<br/><br/>|{\\n533p }{\\n533a }{\\n533b }{\\n533c }{\\n533d }{\\n533e }{\\n533f }{\\n533m }{\\n533n }{\\n533t }{\\n533x }{\\n533z }|\r\n#535|<br/><br/>|{\\n5353 }{\\n535a }{\\n535b }{\\n535c }{\\n535d }|\r\n#538|<br/><br/>|{\\n5383 }{\\n538a }{\\n538i }{\\n538u }|\r\n#540|<br/><br/>|{\\n5403 }{\\n540a }{ 540b }{ 540c }{ 540d }{\\n520u }|\r\n#544|<br/><br/>|{\\n5443 }{\\n544a }{\\n544b }{\\n544c }{\\n544d }{\\n544e }{\\n544n }|\r\n#545|<br/><br/>|{\\n545a }{ 545b }{\\n545u }|\r\n#546|<br/><br/>|{\\n5463 }{\\n546a }{ 546b }|\r\n#547|<br/><br/>|{\\n547a }|\r\n#550|<br/><br/>|{ 550a }|\r\n#552|<br/><br/>|{ 552z }{ 552a }{ 552b }{ 552c }{ 552d }{ 552e }{ 552f }{ 552g }{ 552h }{ 552i }{ 552j }{ 552k }{ 552l }{ 552m }{ 552n }{ 562o }{ 552p }{ 552u }|\r\n#555|<br/><br/>|{ 5553 }{ 555a }{ 555b }{ 555c }{ 555d }{ 555u }|\r\n#556|<br/><br/>|{ 556a }{ 506z }|\r\n#563|<br/><br/>|{ 5633 }{ 563a }{ 563u }|\r\n#565|<br/><br/>|{ 5653 }{ 565a }{ 565b }{ 565c }{ 565d }{ 565e }|\r\n#567|<br/><br/>|{ 567a }|\r\n#580|<br/><br/>|{ 580a }|\r\n#581|<br/><br/>|{ 5633 }{ 581a }{ 581z }|\r\n#584|<br/><br/>|{ 5843 }{ 584a }{ 584b }|\r\n#585|<br/><br/>|{ 5853 }{ 585a }|\r\n#586|<br/><br/>|{ 5863 }{ 586a }|\r\n#020|<br/><br/><label>ISBN: </label>|{ 020a }{ 020c }|\r\n#022|<br/><br/><label>ISSN: </label>|{ 022a }|\r\n#222| = |{ 222a }{ 222b }|\r\n#210| = |{ 210a }{ 210b }|\r\n#024|<br/><br/><label>Standard No.: </label>|{ 024a }{ 024c }{ 024d }{ 0242 }|\r\n#027|<br/><br/><label>Standard Tech. Report. No.: </label>|{ 027a }|\r\n#028|<br/><br/><label>Publisher. No.: </label>|{ 028a }{ 028b }|\r\n#013|<br/><br/><label>Patent No.: </label>|{ 013a }{ 013b }{ 013c }{ 013d }{ 013e }{ 013f }|\r\n#030|<br/><br/><label>CODEN: </label>|{ 030a }|\r\n#037|<br/><br/><label>Source: </label>|{ 037a }{ 037b }{ 037c }{ 037f }{ 037g }{ 037n }|\r\n#010|<br/><br/><label>LCCN: </label>|{ 010a }|\r\n#015|<br/><br/><label>Nat. Bib. No.: </label>|{ 015a }{ 0152 }|\r\n#016|<br/><br/><label>Nat. Bib. Agency Control No.: </label>|{ 016a }{ 0162 }|\r\n#600|<br/><br/><label>Subjects--Personal Names: </label>|{\\n6003 }{\\n600a}{ 600b }{ 600c }{ 600d }{ 600e }{ 600f }{ 600g }{ 600h }{--600k}{ 600l }{ 600m }{ 600n }{ 600o }{--600p}{ 600r }{ 600s }{ 600t }{ 600u }{--600x}{--600z}{--600y}{--600v}|\r\n#610|<br/><br/><label>Subjects--Corporate Names: </label>|{\\n6103 }{\\n610a}{ 610b }{ 610c }{ 610d }{ 610e }{ 610f }{ 610g }{ 610h }{--610k}{ 610l }{ 610m }{ 610n }{ 610o }{--610p}{ 610r }{ 610s }{ 610t }{ 610u }{--610x}{--610z}{--610y}{--610v}|\r\n#611|<br/><br/><label>Subjects--Meeting Names: </label>|{\\n6113 }{\\n611a}{ 611b }{ 611c }{ 611d }{ 611e }{ 611f }{ 611g }{ 611h }{--611k}{ 611l }{ 611m }{ 611n }{ 611o }{--611p}{ 611r }{ 611s }{ 611t }{ 611u }{--611x}{--611z}{--611y}{--611v}|\r\n#630|<br/><br/><label>Subjects--Uniform Titles: </label>|{\\n630a}{ 630b }{ 630c }{ 630d }{ 630e }{ 630f }{ 630g }{ 630h }{--630k }{ 630l }{ 630m }{ 630n }{ 630o }{--630p}{ 630r }{ 630s }{ 630t }{--630x}{--630z}{--630y}{--630v}|\r\n#648|<br/><br/><label>Subjects--Chronological Terms: </label>|{\\n6483 }{\\n648a }{--648x}{--648z}{--648y}{--648v}|\r\n#650|<br/><br/><label>Subjects--Topical Terms: </label>|{\\n6503 }{\\n650a}{ 650b }{ 650c }{ 650d }{ 650e }{--650x}{--650z}{--650y}{--650v}|\r\n#651|<br/><br/><label>Subjects--Geographic Terms: </label>|{\\n6513 }{\\n651a}{ 651b }{ 651c }{ 651d }{ 651e }{--651x}{--651z}{--651y}{--651v}|\r\n#653|<br/><br/><label>Subjects--Index Terms: </label>|{ 653a }|\r\n#654|<br/><br/><label>Subjects--Facted Index Terms: </label>|{\\n6543 }{\\n654a}{--654b}{--654x}{--654z}{--654y}{--654v}|\r\n#655|<br/><br/><label>Index Terms--Genre/Form: </label>|{\\n6553 }{\\n655a}{--655b}{--655x }{--655z}{--655y}{--655v}|\r\n#656|<br/><br/><label>Index Terms--Occupation: </label>|{\\n6563 }{\\n656a}{--656k}{--656x}{--656z}{--656y}{--656v}|\r\n#657|<br/><br/><label>Index Terms--Function: </label>|{\\n6573 }{\\n657a}{--657x}{--657z}{--657y}{--657v}|\r\n#658|<br/><br/><label>Index Terms--Curriculum Objective: </label>|{\\n658a}{--658b}{--658c}{--658d}{--658v}|\r\n#050|<br/><br/><label>LC Class. No.: </label>|{ 050a }{ / 050b }|\r\n#082|<br/><br/><label>Dewey Class. No.: </label>|{ 082a }{ / 082b }|\r\n#080|<br/><br/><label>Universal Decimal Class. No.: </label>|{ 080a }{ 080x }{ / 080b }|\r\n#070|<br/><br/><label>National Agricultural Library Call No.: </label>|{ 070a }{ / 070b }|\r\n#060|<br/><br/><label>National Library of Medicine Call No.: </label>|{ 060a }{ / 060b }|\r\n#074|<br/><br/><label>GPO Item No.: </label>|{ 074a }|\r\n#086|<br/><br/><label>Gov. Doc. Class. No.: </label>|{ 086a }|\r\n#088|<br/><br/><label>Report. No.: </label>|{ 088a }|','70|10','OPAC ISBD','Textarea'),
('OpacItemLocation','callnum','callnum|ccode|location|library','Show the shelving location of items in the opac','Choice'),
('OpacKohaUrl','1',NULL,'Show \'Powered by Koha\' text on OPAC footer.',NULL),
('OpacLangSelectorMode','both','top|both|footer','Select the location to display the language selector in OPAC','Choice'),
('OPACLanguages','en',NULL,'Set the default language in the OPAC.','Languages'),
('opaclanguagesdisplay','0','','If ON, enables display of Change Language feature on OPAC','YesNo'),
('opaclayoutstylesheet','opac.css','','Enter the name of the layout CSS stylesheet to use in the OPAC','free'),
('OPACLocalCoverImages','0','1','Display local cover images on OPAC search and details pages.','YesNo'),
('OpacLocationBranchToDisplay','holding','holding|home|both','In the OPAC, under location show which branch for Location in the record details.','Choice'),
('OpacLocationOnDetail','holding','holding|home|both|column','In the OPAC detail, display the shelving location on its own column or under a library columns.',  'Choice'),
('OpacMaintenance','0','','If ON, enables maintenance warning in OPAC','YesNo'),
('OPACMandatoryHoldDates', '', '|start|end|both', 'Define which hold dates are required on OPAC reserve form', 'Choice'),
('OpacMaxItemsToDisplay','50','','Max items to display at the OPAC on a biblio detail','Integer'),
('OpacMetaDescription','','','This description will show in search engine results (160 characters).','Textarea'),
('OPACMySummaryHTML','','70|10','Enter the HTML that will appear in a column on the \'my summary\' and \'my checkout history\' tabs when a user is logged in to the OPAC. Enter {BIBLIONUMBER}, {TITLE}, {AUTHOR}, or {ISBN} in place of their respective variables in the HTML. Leave blank to disable.','Textarea'),
('OpacNewsLibrarySelect','0','','Show selector for branches on OPAC news page','YesNo'),
('OpacNoItemTypeImages','0',NULL,'If ON, disables itemtype images in the OPAC','YesNo'),
('OPACNoResultsFound','','70|10','Display this HTML when no results are found for a search in the OPAC','Textarea'),
('OPACNumbersPreferPhrase','0',NULL,'Control the use of phr operator in callnumber and standard number OPAC searches','YesNo'),
('OPACnumSearchResults','20',NULL,'Specify the maximum number of results to display on a page of results','Integer'),
('OPACnumSearchResultsDropdown', 0, NULL, 'Enable option list of number of results per page to show in OPAC search results','YesNo'),
('OPACOpenURLItemTypes', '', NULL, 'Show the OpenURL link only for these item types', 'Free'),
('OpacPasswordChange','1',NULL,'If ON, enables patron-initiated password change in OPAC (disable it when using LDAP auth)','YesNo'),
('OPACPatronDetails','1','','If OFF the patron details tab in the OPAC is disabled.','YesNo'),
('OPACpatronimages','0',NULL,'Enable patron images in the OPAC','YesNo'),
('OPACPlayMusicalInscripts','0','','If displayed musical inscripts, play midi conversion on the OPAC record details page.','YesNo'),
('OPACPopupAuthorsSearch','0','','Display the list of authors when clicking on one author.','YesNo'),
('OPACPrivacy','0',NULL,'if ON, allows patrons to define their privacy rules (checkout history)','YesNo'),
('OpacPublic','1',NULL,'Turn on/off public OPAC','YesNo'),
('opacreadinghistory','1','','If ON, enables display of Patron Circulation History in OPAC','YesNo'),
('OpacRenewalAllowed','1',NULL,'If ON, users can renew their issues directly from their OPAC account','YesNo'),
('OpacRenewalBranch','checkoutbranch','itemhomebranch|patronhomebranch|checkoutbranch|none','Choose how the branch for an OPAC renewal is recorded in statistics','Choice'),
('OPACReportProblem', 0, NULL, 'Allow patrons to submit problem reports for OPAC pages to the library or Koha Administrator', 'YesNo'),
('OpacResetPassword','0','','Shows the ''Forgot your password?'' link in the OPAC','YesNo'),
('OPACResultsLibrary', 'homebranch', 'homebranch|holdingbranch', 'Defines whether the OPAC displays the holding or home branch in search results when using XSLT', 'Choice'),
('OPACResultsMaxItems','1','','Maximum number of available items displayed in search results','Integer'),
('OPACResultsMaxItemsUnavailable','0','','Maximum number of unavailable items displayed in search results','Integer'),
('OPACResultsUnavailableGroupingBy','branch','branch|substatus|branchonly','Group OPAC XSLT results by branch and substatus, or substatus only, or branch only','Choice'),
('OPACSearchForTitleIn','<a href=\"https://worldcat.org/search?q={TITLE}\" target=\"_blank\">Other Libraries (WorldCat)</a>\n<a href=\"https://scholar.google.com/scholar?q={TITLE}\" target=\"_blank\">Other Databases (Google Scholar)</a>\n<a href=\"https://www.bookfinder.com/search/?author={AUTHOR}&amp;title={TITLE}&amp;st=xl&amp;ac=qr\" target=\"_blank\">Online Stores (Bookfinder.com)</a>\n<a href=\"https://openlibrary.org/search?author=({AUTHOR})&title=({TITLE})\" target=\"_blank\">Open Library (openlibrary.org)</a>','70|10','Enter the HTML that will appear in the \'Search for this title in\' box on the detail page in the OPAC.  Enter {TITLE}, {AUTHOR}, or {ISBN} in place of their respective variables in the URL. Leave blank to disable \'More Searches\' menu.','Textarea'),
('OpacSeparateHoldings','0',NULL,'Separate current branch holdings from other holdings (OPAC)','YesNo'),
('OpacSeparateHoldingsBranch','homebranch','homebranch|holdingbranch','Branch used to separate holdings (OPAC)','Choice'),
('opacSerialDefaultTab','subscriptions','holdings|serialcollection|subscriptions','Define the default tab for serials in OPAC.','Choice'),
('OPACSerialIssueDisplayCount','3','','Number of serial issues to display per subscription in the OPAC','Integer'),
('OPACShelfBrowser','1','','Enable/disable Shelf Browser on item details page. WARNING: this feature is very resource consuming on collections with large numbers of items.','YesNo'),
('OPACShibOnly','0','','If ON enables shibboleth only authentication for the opac','YesNo'),
('OPACShowCheckoutName','0','','Displays in the OPAC the name of patron who has checked out the material. WARNING: Most sites should leave this off. It is intended for corporate or special sites which need to track who has the item.','YesNo'),
('OPACShowHoldQueueDetails','none','none|priority|holds|holds_priority','Show holds details in OPAC','Choice'),
('OPACShowMusicalInscripts','0','','Display musical inscripts on the OPAC record details page when available.','YesNo'),
('OPACShowOpenURL', '0', NULL, 'Enable display of OpenURL links in OPAC search results and detail page', 'YesNo'),
('OpacShowRecentComments','0',NULL,'If ON a link to recent comments will appear in the OPAC masthead','YesNo'),
('OPACShowSavings', '', 'checkouthistory|summary|user', 'Show on the OPAC the total amount a patron has saved by using a library instead of purchasing, based on replacement prices', 'multiple'),
('OPACShowUnusedAuthorities','1','','Show authorities that are not being used in the OPAC.','YesNo'),
('OpacStarRatings','all','disable|all|details',NULL,'Choice'),
('OPACSuggestionAutoFill','0',NULL,'Automatically fill OPAC suggestion form with data from Google Books API','YesNo'),
('OpacSuggestionManagedBy',1,'','Show the name of the staff member who managed a suggestion in OPAC','YesNo'),
('OPACSuggestionMandatoryFields','title','','Define the mandatory fields for a patron purchase suggestions made via OPAC.','multiple'),
('OPACSuggestionUnwantedFields',NULL,'','Define the hidden fields for a patron purchase suggestions made via OPAC.','multiple'),
('OpacSuppression','0','','Turn ON the OPAC Suppression feature, requires further setup, ask your system administrator for details','YesNo'),
('OpacSuppressionByIPRange','','','Restrict the suppression to IP adresses outside of the IP range','free'),
('OpacSuppressionRedirect','1','Redirect the opac detail page for suppressed records to an explanatory page (otherwise redirect to 404 error page)','','YesNo'),
('opacthemes','bootstrap','','Define the current theme for the OPAC interface.','Themes'),
('OpacTopissue','0',NULL,'If ON, enables the \'most popular items\' link on OPAC. Warning, this is an EXPERIMENTAL feature, turning ON may overload your server','YesNo'),
('OpacTrustedCheckout', '0', NULL, 'Allow logged in OPAC users to check out to themselves', 'YesNo'),
('OPACURLOpenInNewWindow','0',NULL,'If ON, URLs in the OPAC open in a new window','YesNo'),
('OPACUserCSS','',NULL,'Add CSS to be included in the OPAC in an embedded <style> tag.','free'),
('OPACUserJS','','70|10','Define custom javascript for inclusion in OPAC','Textarea'),
('opacuserlogin','1',NULL,'Enable or disable display of user login features','YesNo'),
('OPACUserSummary', 1, NULL, "Show the summary of a logged in user's checkouts, overdues, holds and fines on the mainpage", 'YesNo'),
('OPACViewOthersSuggestions','0',NULL,'If ON, allows all suggestions to be displayed in the OPAC','YesNo'),
('OPACXSLTDetailsDisplay','default','','Enable XSL stylesheet control over details page display on OPAC','Free'),
('OPACXSLTListsDisplay','default','','Enable XSLT stylesheet control over lists pages display on OPAC','Free'),
('OPACXSLTResultsDisplay','default','','Enable XSL stylesheet control over results page display on OPAC','Free'),
('OpenLibraryCovers','0',NULL,'If ON Openlibrary book covers will be show','YesNo'),
('OpenLibrarySearch','0',NULL,'If Yes Open Library search results will show in OPAC','YesNo'),
('OpenURLImageLocation', '', NULL, 'Location of image for OpenURL links', 'Free'),
('OpenURLResolverURL', '', NULL, 'URL of OpenURL Resolver', 'Free'),
('OpenURLText', '', NULL, 'Text of OpenURL links (or image title if OpenURLImageLocation is defined)', 'Free'),
('OrderPdfFormat','pdfformat::layout3pages','Controls what script is used for printing (basketgroups)','','free'),
('OrderPriceRounding','','|nearest_cent','Local preference for rounding orders before calculations to ensure correct calculations','Choice'),
('OverDriveAuthName','',NULL,'Authentication for OverDrive integration, used as fallback when no OverDrive library authnames are set','Free'),
('OverDriveCirculation','0','','Enable client to see their OverDrive account','YesNo'),
('OverDriveClientKey','',NULL,'Client key for OverDrive integration','Free'),
('OverDriveClientSecret','',NULL,'Client key for OverDrive integration','Free'),
('OverDriveLibraryID','', NULL,'Library ID for OverDrive integration','Integer'),
('OverDrivePasswordRequired','0','','Does the library require passwords for OverDrive SIP authentication','YesNo'),
('OverDriveUsername','cardnumber','cardnumber|userid','Which patron information should be passed as OverDrive username','Choice'),
('OverDriveWebsiteID','', NULL, 'WebsiteID provided by OverDrive', 'Free'),
('OverdueNoticeCalendar',0,NULL,'Take the calendar into consideration when generating overdue notices','YesNo'),
('OverdueNoticeFrom', 'cron', 'cron|item-issuebranch|item-homebranch', 'Organize and send overdue notices by item home library or checkout library', 'Choice'),
('OverduesBlockCirc','noblock','noblock|confirmation|block','When checking out an item should overdues block checkout, generate a confirmation dialogue, or allow checkout','Choice'),
('OverduesBlockRenewing','allow','allow|blockitem|block','If any of patron checked out documents is late, should renewal be allowed, blocked only on overdue items or blocked on whatever checked out document','Choice'),
('PassItemMarcToXSLT','0',NULL,'If enabled, item fields in the MARC record will be made avaiable to XSLT sheets. Otherwise they will be removed.','YesNo'),
('PatronAnonymizeDelay','',NULL,'Delay for anonymizing patrons', 'Integer'),
('PatronAutoComplete','1','Try|Don\'t try','to guess the patron being entered while typing a patron search for circulation or patron search. Only returns the first 10 results at a time.','YesNo'),
('PatronDuplicateMatchingAddFields','surname|firstname|dateofbirth', NULL,'A list of fields separated by "|" to deduplicate patrons when created','Free'),
('patronimages','0',NULL,'Enable patron images for the staff interface','YesNo'),
('PatronQuickAddFields',  '', NULL ,  'A list of fields separated by "|" to be displayed along with mandatory fields in the patron quick add form if chosen at patron entry',  'Free' ),
('PatronRemovalDelay','',NULL,'Delay for removing anonymized patrons', 'Integer'),
('PatronRestrictionTypes','0',NULL,'Specify type of patron restriction being applied', 'YesNo'),
('PatronSelfModificationBorrowerUnwantedField','',NULL,'Name the fields you don\'t want to display when a patron is editing their information via the OPAC.','free'),
('PatronSelfModificationMandatoryField','',NULL,'Define the required fields when a patron is editing their information via the OPAC','free'),
('PatronSelfRegistration','0',NULL,'If enabled, patrons will be able to register themselves via the OPAC.','YesNo'),
('PatronSelfRegistrationBorrowerMandatoryField','surname|firstname',NULL,'Choose the mandatory fields for a patron\'s account, when registering via the OPAC.','free'),
('PatronSelfRegistrationBorrowerUnwantedField','',NULL,'Name the fields you don\'t want to display when registering a new patron via the OPAC.','free'),
('PatronSelfRegistrationConfirmEmail', '0', NULL, 'Require users to confirm their email address by entering it twice.', 'YesNo'),
('PatronSelfRegistrationDefaultCategory','','','A patron registered via the OPAC will receive a borrower category code set in this system preference.','free'),
('PatronSelfRegistrationEmailMustBeUnique', '0', 'If set, the field borrowers.email will be considered as a unique field on self registering', NULL, 'YesNo'),
('PatronSelfRegistrationExpireTemporaryAccountsDelay','0',NULL,'If PatronSelfRegistrationDefaultCategory is enabled, this system preference controls how long a patron can have a temporary status before the account is deleted automatically. It is an integer value representing a number of days to wait before deleting a temporary patron account. Setting it to 0 disables the deleting of temporary accounts.','Integer'),
('PatronSelfRegistrationLibraryList','',NULL,'Only display libraries listed. If empty, all libraries are displayed.','Free'),
('PatronSelfRegistrationPrefillForm','1',NULL,'Display password and prefill login form after a patron has self registered','YesNo'),
('PatronSelfRegistrationVerifyByEmail','0',NULL,'If enabled, any patron attempting to register themselves via the OPAC will be required to verify themselves via email to activate their account.','YesNo'),
('PatronsPerPage','20','20','Number of Patrons Per Page displayed by default','Integer'),
('PhoneNotification','0',NULL,'If ON, enables generation of phone notifications to be sent by plugins','YesNo'),
('PrefillGuaranteeField', 'phone,email,streetnumber,address,city,state,zipcode,country', NULL, 'Prefill these fields in guarantee member entry form from guarantor patron record', 'Multiple'),
('PrefillItem','0','','When a new item is added, should it be prefilled with last created item values?','YesNo'),
('PreservationModule', '0', NULL, 'Enable the preservation module', 'YesNo'),
('PreservationNotForLoanDefaultTrainIn', '', '', 'Not for loan to apply to items removed from the preservation waiting list', 'TextArea'),
('PreservationNotForLoanWaitingListIn', '', '', 'Not for loan to apply to items added to the preservation waiting list', 'TextArea'),
('PreserveSerialNotes','1','','When a new "Expected" issue is generated, should it be prefilled with last created issue notes?','YesNo'),
('previousIssuesDefaultSortOrder','asc','asc|desc','Specify the sort order of Previous Issues on the circulation page','Choice'),
('PrintNoticesMaxLines','0','','If greater than 0, sets the maximum number of lines an overdue notice will print. If the number of items is greater than this number, the notice will end with a warning asking the borrower to check their online account for a full list of overdue items.','Integer'),
('PrivacyPolicyConsent','','Enforced|Permissive|Disabled','Data privacy policy consent in the OPAC', 'Choice'),
('PrivacyPolicyURL','',NULL,'This URL is used in messages about GDPR consents.', 'Free'),
('ProcessingFeeNote', '', NULL, 'Set the text to be recorded in the column note, table accountlines when the processing fee (defined in item type) is applied', 'textarea'),
('ProtectSuperlibrarianPrivileges','1',NULL,'If enabled, non-superlibrarians cannot set superlibrarian privileges','YesNo'),
('Pseudonymization','0',NULL,'If enabled patrons and transactions will be copied in a separate table for statistics purpose','YesNo'),
('PseudonymizationPatronFields','','title,city,state,zipcode,country,branchcode,categorycode,dateenrolled,sex,sort1,sort2','Patron fields to copy to the pseudonymized_transactions table','multiple'),
('PseudonymizationTransactionFields','','datetime,branchcode,transaction_type,itemnumber,itemtype,holdingbranch,location,itemcallnumber,ccode','Transaction fields to copy to the pseudonymized_transactions table','multiple'),
('PurgeListShareInvitesOlderThan', '14', NULL, 'If not empty, number of days used when deleting unaccepted list share invites', 'Integer'),
('PurgeSuggestionsOlderThan', '', NULL, 'If this script is called without the days parameter', 'Integer'),
('QueryAutoTruncate','1',NULL,'If ON, query truncation is enabled by default','YesNo'),
('QueryFuzzy','1',NULL,'If ON, enables fuzzy option for searches','YesNo'),
('QueryRegexEscapeOptions', 'escape', 'dont_escape|escape|unescape_escaped', 'Escape option for regexps delimiters in Elasicsearch queries.', 'Choice'),
('QueryStemming','1',NULL,'If ON, enables query stemming','YesNo'),
('QueryWeightFields','1',NULL,'If ON, enables field weighting','YesNo'),
('QuoteOfTheDay','','intranet,opac','Enable or disable display of Quote of the Day on the OPAC and staff interface home page','multiple'),
('RandomizeHoldsQueueWeight','0',NULL,'if ON, the holds queue in circulation will be randomized, either based on all location codes, or by the location codes specified in StaticHoldsQueueWeight','YesNo'),
('RealTimeHoldsQueue', '0', NULL, 'Enable updating the holds queue in real time', 'YesNo'),
('RecallsLog','1',NULL,'If ON, log create/cancel/expire/fulfill actions on recalls','YesNo'),
('RecallsMaxPickUpDelay','7',NULL,'Define the maximum time a recall can be awaiting pickup','Integer'),
('RecordLocalUseOnReturn','0',NULL,'If ON, statistically record returns of unissued items as local use, instead of return','YesNo'),
('RecordStaffUserOnCheckout', '0', '', 'If enabled, when an item is checked out, the user who checked out the item is recorded', 'YesNo'),
('RedirectGuaranteeEmail', '0', NULL, 'Enable the ability to redirect guarantee email messages to guarantor.', 'YesNo'),
('Reference_NFL_Statuses','1|2',NULL,'Contains not for loan statuses considered as available for reference','Free'),
('RefundLostOnReturnControl','CheckinLibrary','CheckinLibrary|ItemHomeBranch|ItemHoldingBranch','If a lost item is returned, choose which branch to pick rules for refunding.','Choice'),
('RenewAccruingItemInOpac','0','','If enabled, when the fines on an item accruing is paid off in the OPAC via a payment plugin, attempt to renew that item. If the syspref "RenewalPeriodBase" is set to "due date", renewed items may still be overdue','YesNo'),
('RenewAccruingItemWhenPaid','0','','If enabled, when the fines on an item accruing is paid off, attempt to renew that item. If the syspref "RenewalPeriodBase" is set to "due date", renewed items may still be overdue','YesNo'),
('RenewalLog','0','','If ON, log information about renewals','YesNo'),
('RenewalPeriodBase','date_due','date_due|now','Set whether the renewal date should be counted from the date_due or from the moment the Patron asks for renewal ','Choice'),
('RenewalSendNotice','0','',NULL,'YesNo'),
('RenewSerialAddsSuggestion','0',NULL,'If ON, adds a new suggestion at serial subscription renewal','YesNo'),
('RentalFeesCheckoutConfirmation', '0', NULL , 'Allow user to confirm when checking out an item with rental fees.', 'YesNo'),
('ReplytoDefault','',NULL,'Use this email address as the replyto in emails','Free'),
('ReportsLog','0',NULL,'If ON, log information about reports.','YesNo'),
('RequireCashRegister','0',NULL,'Require a cash register when collecting a payment','YesNo'),
('RequireChoosingExistingAuthority','0',NULL,'Require existing authority selection in controlled fields during cataloging.','YesNo'),
('RequirePaymentType','0','','Require staff to select a payment type when a payment is made','YesNo'),
('RequireStrongPassword','1','','Require a strong login password for staff and patrons','YesNo'),
('ReservesControlBranch','PatronLibrary','ItemHomeLibrary|PatronLibrary','Branch checked for members reservations rights','Choice'),
('ReservesMaxPickUpDelay','7','','Define the Maximum delay to pick up an item on hold','Integer'),
('ReservesNeedReturns','1','','If ON, a hold placed on an item available in this library must be checked-in, otherwise, a hold on a specific item, that is in the library & available is considered available','YesNo'),
('RESTBasicAuth','0',NULL,'If enabled, Basic authentication is enabled for the REST API.','YesNo'),
('RESTdefaultPageSize','20','','Default page size for endpoints listing objects','Integer'),
('RESTOAuth2ClientCredentials','0',NULL,'If enabled, the OAuth2 client credentials flow is enabled for the REST API.','YesNo'),
('RESTPublicAnonymousRequests','1',NULL,'If enabled, the API will allow anonymous access to public routes that don\'t require authenticated access.','YesNo'),
('RESTPublicAPI','1',NULL,'If enabled, the REST API will expose the /public endpoints.','YesNo'),
('RestrictedPageContent','',NULL,'HTML content of the restricted page','TextArea'),
('RestrictedPageLocalIPs','',NULL,'Beginning of IP addresses considered as local (comma separated ex: "127.0.0,127.0.2")','Free'),
('RestrictedPageTitle','',NULL,'Title of the restricted page (breadcrumb and header)','Free'),
('RestrictionBlockRenewing','0',NULL,'If patron is restricted, should renewal be allowed or blocked','YesNo'),
('RetainCatalogSearchTerms', '1', NULL, 'If enabled, searches entered into the catalog search bar will be retained', 'YesNo'),
('RetainPatronsSearchTerms', '1', NULL, 'If enabled, searches entered into the checkout and patrons search bar will be retained', 'YesNo'),
('ReturnBeforeExpiry','0',NULL,'If ON, checkout will be prevented if returndate is after patron card expiry','YesNo'),
('ReturnLog','1',NULL,'If ON, enables the circulation (returns) log','YesNo'),
('ReturnpathDefault','',NULL,'Use this email address as return path or bounce address for undeliverable emails','Free'),
('RisExportAdditionalFields',  '', NULL ,  'Define additional RIS tags to export from MARC records in YAML format as an associative array with either a marc tag/subfield combination as the value, or a list of tag/subfield combinations.',  'textarea'),
('RoundFinesAtPayment','0', NULL,'If enabled any fines with fractions of a cent will be rounded to the nearest cent when payments are coll    ected. e.g. 1.004 will be paid off by a 1.00 payment','YesNo'),
('RoutingListAddReserves','0','','If ON the patrons on routing lists are automatically added to holds on the issue.','YesNo'),
('RoutingListNote','To change this note edit <a href=\"/cgi-bin/koha/admin/preferences.pl?op=search&searchfield=RoutingListNote#jumped\">RoutingListNote</a> system preference.','70|10','Define a note to be shown on all routing lists','Textarea'),
('RoutingSerials','1',NULL,'If ON, serials routing is enabled','YesNo'),
('SavedSearchFilters', '0', NULL, 'Allow staff with permission to create/edit custom search filters', 'YesNo'),
('SCOAllowCheckin','0','','If enabled, patrons may return items through the Web-based Self Checkout','YesNo'),
('SCOLoadCheckoutsByDefault','1','','If enabled, load the list of a patrons checkouts when they log in to the Self Checkout','YesNo'),
('SCOUserCSS','',NULL,'Add CSS to be included in the SCO module in an embedded <style> tag.','free'),
('SCOUserJS','',NULL,'Define custom javascript for inclusion in the SCO module','free'),
('SearchEngine','Zebra','Elasticsearch|Zebra','Search Engine','Choice'),
('SearchLimitLibrary', 'homebranch', 'homebranch|holdingbranch|both', "When limiting search results with a library or library group, use the item's home library, or holding library, or both.", 'Choice'),
('SearchMyLibraryFirst','0',NULL,'If ON, OPAC searches return results limited by the user\'s library by default if they are logged in','YesNo'),
('SearchWithISBNVariations','0',NULL,'If enabled, search on all variations of the ISBN','YesNo'),
('SearchWithISSNVariations','0',NULL,'If enabled, search on all variations of the ISSN','YesNo'),
('SelfCheckAllowByIPRanges','',NULL,'(Leave blank if not used. Use ranges or simple ip addresses separated by spaces, like <code>192.168.1.1 192.168.0.0/24</code>.)','Short'),
('SelfCheckInModule', 0, NULL, 'Enable the standalone self-checkin module.', 'YesNo'),
('SelfCheckInTimeout','120','','Define the number of seconds before the self check-in module times out.','Integer'),
('SelfCheckInUserCSS','',NULL,'Add CSS to be included in the self check-in module in an embedded <style> tag.','free'),
('SelfCheckInUserJS','',NULL,'Define custom javascript for inclusion in the self check-in module.','free'),
('SelfCheckoutByLogin','1',NULL,'Have patrons login into the web-based self checkout system with their username/password or their cardnumber','YesNo'),
('SelfCheckReceiptPrompt','1','NULL','If ON, print receipt dialog pops up when self checkout is finished','YesNo'),
('SelfCheckTimeout','120','','Define the number of seconds before the Web-based Self Checkout times out a patron','Integer'),
('SendAllEmailsTo','',NULL,'All emails will be redirected to this email if it is not empty','free'),
('SeparateHoldings','0',NULL,'Separate current branch holdings from other holdings','YesNo'),
('SeparateHoldingsBranch','homebranch','homebranch|holdingbranch','Branch used to separate holdings','Choice'),
('SerialsDefaultEmailAddress', '', NULL, 'Default email address used as reply-to for notices sent by the serials module.', 'Free'),
('SerialsDefaultReplyTo', '', NULL, 'Default email address that serials notices are sent from.', 'Free'),
('SerialsSearchResultsLimit', NULL, NULL, 'Serials search results limit', 'integer'),
('SessionRestrictionByIP','1','Check for change in remote IP address for session security. Disable only when remote IP address changes frequently.','','YesNo'),
('SessionStorage','mysql','mysql|Pg|tmp','Use database or a temporary file for storing session data','Choice'),
('ShelfBrowserUsesCcode','1','0','Use the item collection code when finding items for the shelf browser.','YesNo'),
('ShelfBrowserUsesHomeBranch','1','1','Use the item home branch when finding items for the shelf browser.','YesNo'),
('ShelfBrowserUsesLocation','1','1','Use the item location when finding items for the shelf browser.','YesNo'),
('ShowAllCheckins', '0', '', 'Show all checkins', 'YesNo'),
('ShowComponentRecords', 'nowhere', 'nowhere|staff|opac|both','In which record detail pages to show list of the component records, as linked via 773','Choice'),
('ShowHeadingUse', '0', NULL, 'Show whether authority record contains an established heading that conforms to descriptive cataloguing rules, and can therefore be used as a main/added entry, or subject, or series title', 'YesNo'),
('showLastPatron','0','','If ON, enables the last patron feature in the intranet','YesNo'),
('showLastPatronCount', '10', '', 'How many patrons should showLastPatron remember', 'Integer'),
('ShowPatronImageInWebBasedSelfCheck','0','','If ON, displays patron image when a patron uses web-based self-checkout','YesNo'),
('ShowReviewer','full','none|full|first|surname|firstandinitial|username','Choose how a commenter\'s identity is presented alongside comments in the OPAC','Choice'),
('ShowReviewerPhoto','1','','If ON, photo of reviewer will be shown beside comments in OPAC','YesNo'),
('SIP2AddOpacMessagesToScreenMessage','1','','If enabled, patron OPAC messages will be included in the SIP2 screen message','YesNo'),
('SIP2SortBinMapping','',NULL,'Use the following mappings to determine the sort_bin of a returned item. The mapping should be on the form \"branchcode:item field:item field value:sort bin number\", with one mapping per line.','free'),
('SkipHoldTrapOnNotForLoanValue','',NULL,'If set, Koha will never trap items for hold with this notforloan value','Integer'),
('SlipCSS','',NULL,'Slips CSS url.','free'),
('SMSSendDriver','','','Sets which SMS::Send driver is used to send SMS messages.','free'),
('SMSSendPassword', '', '', 'Password used to send SMS messages', 'free'),
('SMSSendUsername', '', '', 'Username/Login used to send SMS messages', 'free'),
('SocialNetworks','','facebook|linkedin|email','Enable/Disable social networks links in opac detail pages','Choice'),
('SpecifyDueDate','1','','Define whether to display \"Specify Due Date\" form in Circulation','YesNo'),
('SpecifyReturnDate',1,'','Define whether to display \"Specify Return Date\" form in Circulation','YesNo'),
('SpineLabelAutoPrint','0','','If this setting is turned on, a print dialog will automatically pop up for the quick spine label printer.','YesNo'),
('SpineLabelFormat','<itemcallnumber><copynumber>','30|10','This preference defines the format for the quick spine label printer. Just list the fields you would like to see in the order you would like to see them, surrounded by <>, for example <itemcallnumber>.','Textarea'),
('SpineLabelShowPrintOnBibDetails','0','','If turned on, a \"Print label\" link will appear for each item on the bib details page in the staff interface.','YesNo'),
('staffClientBaseURL','',NULL,'Specify the base URL of the staff interface starting with http:// or https://. Do not include a trailing slash in the URL. (This must be filled in correctly for CAS, svc, and load_testing to work.)','free'),
('StaffDetailItemSelection', '1', NULL, 'Enable item selection in record detail page', 'YesNo'),
('StaffHighlightedWords','1','','Highlight search terms on staff interface','YesNo'),
('StaffLangSelectorMode','footer','top|both|footer','Select the location to display the language selector in staff interface','Choice'),
('StaffLoginInstructions', '', NULL, 'HTML to go into the login box for the staff interface','Free'),
('StaffLoginLibraryBasedOnIP', '1','', 'Set the logged in library for the user based on their current IP','YesNo'),
('StaffLoginRestrictLibraryByIP','0',NULL,'If ON, IP authentication is enabled, blocking access to the staff interface from unauthorized IP addresses based on branch','YesNo'),
('StaffSearchResultsDisplayBranch','holdingbranch','holdingbranch|homebranch','Controls the display of the home or holding branch for staff search results','Choice'),
('StaffSerialIssueDisplayCount','3','','Number of serial issues to display per subscription in the staff interface','Integer'),
('staffShibOnly','0','','If ON enables shibboleth only authentication for the staff client','YesNo'),
('StaticHoldsQueueWeight','0',NULL,'Specify a list of library location codes separated by commas -- the list of codes will be traversed and weighted with first values given higher weight for holds fulfillment -- alternatively, if RandomizeHoldsQueueWeight is set, the list will be randomly selective','Integer'),
('StatisticsFields','location|itype|ccode', NULL, 'Define Fields (from the items table) used for statistics members','Free'),
('StockRotation','0',NULL,'If ON, enables the stock rotation module','YesNo'),
('StoreLastBorrower','0','','If ON, the last borrower to return an item will be stored in items.last_returned_by','YesNo'),
('StripWhitespaceChars','0',NULL,'Strip leading and trailing whitespace characters and inner newlines from input fields when cataloguing bibliographic and authority records.','YesNo'),
('SubfieldsToAllowForRestrictedBatchmod','','Define a list of subfields for which edition is authorized when items_batchmod_restricted permission is enabled, separated by spaces. Example: 995\$f 995\$h 995\$j',NULL,'Free'),
('SubfieldsToAllowForRestrictedEditing','','Define a list of subfields for which edition is authorized when edit_items_restricted permission is enabled, separated by spaces. Example: 995\$f 995\$h 995\$j',NULL,'Free'),
('SubfieldsToUseWhenPrefill','','','Define a list of subfields to use when prefilling items (separated by space)','Free'),
('SubscriptionDuplicateDroppedInput','','','List of fields which must not be rewritten when a subscription is duplicated (Separated by pipe |)','Free'),
('SubscriptionHistory','simplified','simplified|full','Define the display preference for serials issue history in OPAC','Choice'),
('SubscriptionLog','1',NULL,'If ON, enables subscriptions log','YesNo'),
('suggestion','1','','If ON, enables patron suggestions feature in OPAC','YesNo'),
('suggestionPatronCategoryExceptions', '', '', 'List the patron categories not affected by suggestion system preference if on', 'Free'),
('SuspendHoldsIntranet','1','Allow holds to be suspended from the intranet.',NULL,'YesNo'),
('SuspendHoldsOpac','1','Allow holds to be suspended from the OPAC.',NULL,'YesNo'),
('SuspensionsCalendar','noSuspensionsWhenClosed','ignoreCalendar|noSuspensionsWhenClosed','Specify whether to use the Calendar in calculating suspension expiration','Choice'),
('SvcMaxReportRows','10',NULL,'Maximum number of rows to return via the report web service.','Integer'),
('SwitchOnSiteCheckouts','0',NULL,'Automatically switch an on-site checkout to a normal checkout','YesNo'),
('SyndeticsAuthorNotes','0','','Display Notes about the Author on OPAC from Syndetics','YesNo'),
('SyndeticsAwards','0','','Display Awards on OPAC from Syndetics','YesNo'),
('SyndeticsClientCode','0','','Client Code for using Syndetics Solutions content','free'),
('SyndeticsCoverImages','0','','Display Cover Images from Syndetics','YesNo'),
('SyndeticsCoverImageSize','MC','MC|LC','Choose the size of the Syndetics Cover Image to display on the OPAC detail page, MC is Medium, LC is Large','Choice'),
('SyndeticsEditions','0','','Display Editions from Syndetics','YesNo'),
('SyndeticsEnabled','0','','Turn on Syndetics Enhanced Content','YesNo'),
('SyndeticsExcerpt','0','','Display Excerpts and first chapters on OPAC from Syndetics','YesNo'),
('SyndeticsReviews','0','','Display Reviews on OPAC from Syndetics','YesNo'),
('SyndeticsSeries','0','','Display Series information on OPAC from Syndetics','YesNo'),
('SyndeticsSummary','0','','Display Summary Information from Syndetics','YesNo'),
('SyndeticsTOC','0','','Display Table of Content information from Syndetics','YesNo'),
('TagsEnabled','1','','Enables or disables all tagging features.  This is the main switch for tags.','YesNo'),
('TagsExternalDictionary','','','Path on server to local ispell executable, used to set $Lingua::Ispell::path  This dictionary is used as a \"whitelist\" of pre-allowed tags.',''),
('TagsInputOnDetail','1','','Allow users to input tags from the detail page.','YesNo'),
('TagsInputOnList','0','','Allow users to input tags from the search results list.','YesNo'),
('TagsModeration','0','','Require tags from patrons to be approved before becoming visible.','YesNo'),
('TagsShowOnDetail','10','','Number of tags to display on detail page.  0 is off.','Integer'),
('TagsShowOnList','6','','Number of tags to display on search results list.  0 is off.','Integer'),
('TalkingTechItivaPhoneNotification','0',NULL,'If ON, enables Talking Tech I-tiva phone notifications','YesNo'),
('TaxRates','0','','Default Goods and Services tax rate NOT in %, but in numeric form (0.12 for 12%), set to 0 to disable GST','Integer'),
('template','prog','','Define the preferred staff interface template','Themes'),
('ThingISBN','0','','Use with FRBRizeEditions. If ON, Koha will use the ThingISBN web service in the Editions tab on the detail pages.','YesNo'),
('TimeFormat','24hr','12hr|24hr','Defines the global time format for visual output.','Choice'),
('timeout','1d',NULL,'Inactivity timeout for cookies authentication','Free'),
('todaysIssuesDefaultSortOrder','desc','asc|desc','Specify the sort order of Todays Issues on the circulation page','Choice'),
('TraceCompleteSubfields','0','0','Force subject tracings to only match complete subfields.','YesNo'),
('TraceSubjectSubdivisions','0','1','Create searches on all subdivisions for subject tracings.','YesNo'),
('TrackClicks','0',NULL,'Track links clicked','Integer'),
('TrackLastPatronActivityTriggers','',NULL,'If set, the field borrowers.lastseen will be updated everytime a patron performs a selected action','multiple'),
('TransfersBlockCirc','1',NULL,'Should the transfer modal block circulation staff from continuing scanning items','YesNo'),
('TransfersMaxDaysWarning','3',NULL,'Define the days before a transfer is suspected of having a problem','Integer'),
('TransferWhenCancelAllWaitingHolds','0',NULL,'Transfer items when cancelling all waiting holds','YesNo'),
('TranslateNotices','0',NULL, 'Allow notices to be translated','YesNo'),
('TrapHoldsOnOrder','1',NULL,'If enabled, Koha will trap holds for on order items ( notforloan < 0 )','YesNo'),
('TwoFactorAuthentication', 'disabled', 'enforced|enabled|disabled', 'Enables two-factor authentication', 'Choice'),
('UNIMARCAuthorityField100','afrey50      ba0',NULL,'Define the contents of UNIMARC authority control field 100 position 08-35','Textarea'),
('UNIMARCAuthorsFacetsSeparator',', ',NULL,'UNIMARC authors facets separator','short'),
('UNIMARCField100Language','fre',NULL,'UNIMARC field 100 default language','short'),
('UniqueItemFields','barcode','','Pipe-separated list of fields that should be unique (used in acquisition module for item creation). Fields must be valid SQL column names of items table','Free'),
('UnseenRenewals','0','','Allow renewals to be recorded as "unseen" by the library, and count against the patrons unseen renewals limit.','YesNo'),
('UnsubscribeReflectionDelay','',NULL,'Delay for locking unsubscribers', 'Integer'),
('UpdateItemLocationOnCheckin', '', 'NULL', 'This is a list of value pairs.\n Examples:\n\nPROC: FIC - causes an item in the Processing Center location to be updated into the Fiction location on check in.\nFIC: GEN - causes an item in the Fiction location to be updated into the General stacks location on check in.\n_BLANK_:FIC - causes an item that has no location to be updated into the Fiction location on check in.\nFIC: _BLANK_ - causes an item in location FIC to be updated to a blank location on check in.\n_ALL_:FIC - causes all items to be updated into the Fiction location on check in.\nPROC: _PERM_ - causes an item that is in the Processing Center to be updated to it''s permanent location.\n\nGeneral rule: if the location value on the left matches the item''s current location, it will be updated to match the location value on the right.\nNote: PROC and CART are special values, for these locations only can location and permanent_location differ, in all other cases an update will affect both. Items in the CART location will be returned to their permanent location on checkout.\n\nThe special term _BLANK_ may be used on either side of a value pair to update or remove the location from items with no location assigned.\nThe special term _ALL_ is used on the left side of the colon (:) to affect all items.\nThe special term _PERM_ is used on the right side of the colon (:) to return items to their permanent location.', 'Free'),
('UpdateItemLocationOnCheckout', '', 'NULL', 'This is a list of value pairs.\n Examples:\n\nPROC: FIC - causes an item in the Processing Center location to be updated into the Fiction location on check out.\nFIC: GEN - causes an item in the Fiction location to be updated into the General stacks location on check out.\n_BLANK_:FIC - causes an item that has no location to be updated into the Fiction location on check out.\nFIC: _BLANK_ - causes an item in location FIC to be updated to a blank location on check out.\n_ALL_:FIC - causes all items to be updated into the Fiction location on check out.\nPROC: _PERM_ - causes an item that is in the Processing Center to be updated to it''s permanent location.\n\nGeneral rule: if the location value on the left matches the item''s current location, it will be updated to match the location value on the right.\nNote: PROC and CART are special values, for these locations only can location and permanent_location differ, in all other cases an update will affect both. Items in the CART location will be returned to their permanent location on checkout.\n\nThe special term _BLANK_ may be used on either side of a value pair to update or remove the location from items with no location assigned.\nThe special term _ALL_ is used on the left side of the colon (:) to affect all items.\nThe special term _PERM_ is used on the right side of the colon (:) to return items to their permanent location.', 'Free'),
('UpdateItemWhenLostFromHoldList','',NULL,'This is a list of values to update an item when it is marked as lost from the holds to pull screen','Free'),
('UpdateNotForLoanStatusOnCheckin', '', 'NULL', 'This is a list of item types and value pairs.\nExamples:\n_ALL_:\n -1: 0\n\nCR:\n 1: 0\n\nWhen an item is checked in, if its item type matches CR then when the value on the left (1) matches the items not for loan value it will be updated to the value on the right.\n\nThe special term _ALL_ is used on the left side of the colon (:) to affect all item types. This does not override all other rules\n\nEach item type needs to be defined on a separate line on the left side of the colon (:).\nEach pair of not for loan values, for that item type, should be listed on separate lines below the item type, each indented by a leading space.', 'Free'),
('UpdateNotForLoanStatusOnCheckout', '', 'NULL', 'This is a list of value pairs. When an item is checked out, if the not for loan value on the left matches the items not for loan value it will be updated to the right-hand value. E.g. ''-1: 0'' will cause an item that was set to ''Ordered'' to now be available for loan. Each pair of values should be on a separate line.', 'Free'),
('UpdateTotalIssuesOnCirc','0',NULL,'Whether to update the totalissues field in the biblio on each circ.','YesNo'),
('UploadPurgeTemporaryFilesDays','',NULL,'If not empty, number of days used when automatically deleting temporary uploads','integer'),
('uppercasesurnames','0',NULL,'If ON, surnames are converted to upper case in patron entry form','YesNo'),
('URLLinkText','',NULL,'Text to display as the link anchor in the OPAC','free'),
('UsageStats', 2, NULL, 'Share anonymous usage data on the Hea Koha community website.', 'integer'),
('UsageStatsCountry', '', NULL, 'The country where your library is located, to be shown on the Hea Koha community website', 'Choice'),
('UsageStatsGeolocation', '', NULL, 'Geolocation of the main library.', 'Free'),
('UsageStatsID', '', NULL, 'This preference is part of Koha but it should not be deleted or updated manually.',  'Free'),
('UsageStatsLastUpdateTime', '', NULL, 'This preference is part of Koha but it should not be deleted or updated manually.', 'Free'),
('UsageStatsLibrariesInfo', '0', NULL, 'Share libraries information', 'YesNo'),
('UsageStatsLibraryName', '', NULL, 'The library name to be shown on Hea Koha community website', 'Free'),
('UsageStatsLibraryType', '', 'public|school|academic|research|private|societyAssociation|corporate|government|religiousOrg|subscription', 'The library type to be shown on the Hea Koha community website', 'Choice'),
('UsageStatsLibraryUrl', '', NULL, 'The library URL to be shown on Hea Koha community website', 'Free'),
('UsageStatsPublicID', '', NULL, 'Public ID for Hea website', 'Free'),
('UseACQFrameworkForBiblioRecords','0','','Use the ACQ framework for the catalog details','YesNo'),
('UseAuthoritiesForTracings','1','0','Use authority record numbers for subject tracings instead of heading strings.','YesNo'),
('UseBranchTransferLimits','0','','If ON, Koha will will use the rules defined in branch_transfer_limits to decide if an item transfer should be allowed.','YesNo'),
('UseCashRegisters','0','','Use cash registers with the accounting system and assign patron transactions to them.','YesNo'),
('UseCirculationDesks','0','','Use circulation desks with circulation.','YesNo'),
('UseControlNumber','0','','If ON, record control number (w subfields) and control number (001) are used for linking of bibliographic records.','YesNo'),
('UseCourseReserves','0',NULL,'Enable the course reserves feature.','YesNo'),
('useDaysMode','Calendar','Calendar|Days|Datedue|Dayweek','Choose the method for calculating due date: select Calendar, Datedue or Dayweek to use the holidays module, and Days to ignore the holidays module','Choice'),
('useDefaultReplacementCost', '0', NULL, 'default replacement cost defined in item type', 'YesNo'),
('useDischarge','0','','Allows librarians to discharge borrowers and borrowers to request a discharge','YesNo'),
('UseEmailReceipts','0','','Send email receipts for payments and write-offs','YesNo'),
('UseICUStyleQuotes','0','1','Tell Koha whether to use ICU style quotes ({) or default (") when tracing subjects .','YesNo'),
('UseLocationAsAQInSIP', '0', '', 'Use permanent_location instead of homebranch for AQ in SIP response', 'YesNo'),
('UseOCLCEncodingLevels','0',NULL,'If enabled, include OCLC encoding levels in leader value builder dropdown for position 17.','YesNo'),
('UseRecalls','0',NULL,'Enable or disable recalls','YesNo'),
('UseTransportCostMatrix','0','','Use Transport Cost Matrix when filling holds','YesNo'),
('UseWYSIWYGinSystemPreferences','0','','Show WYSIWYG editor when editing certain HTML system preferences.','YesNo'),
('viewISBD','1','','Allow display of ISBD view of bibiographic records','YesNo'),
('viewLabeledMARC','0','','Allow display of labeled MARC view of bibiographic records','YesNo'),
('viewMARC','1','','Allow display of MARC view of bibiographic records','YesNo'),
('virtualshelves','1','','If ON, enables Lists management','YesNo'),
('WaitingNotifyAtCheckin','0',NULL,'If ON, notify librarians of waiting holds for the patron whose items they are checking in.','YesNo'),
('WebBasedSelfCheck','0',NULL,'If ON, enables the web-based self-check system','YesNo'),
('WhenLostChargeReplacementFee','1',NULL,'If ON, Charge the replacement price when a patron loses an item.','YesNo'),
('WhenLostForgiveFine','0',NULL,'If ON, Forgives the fines on an item when it is lost.','YesNo'),
('XSLTDetailsDisplay','default','','Enable XSL stylesheet control over details page display on intranet','Free'),
('XSLTListsDisplay','default','','Enable XSLT stylesheet control over lists pages display on intranet','Free'),
('XSLTResultsDisplay','default','','Enable XSL stylesheet control over results page display on intranet','Free'),
('z3950AuthorAuthFields','701,702,700',NULL,'Define the MARC biblio fields for Personal Name Authorities to fill biblio.author','free'),
('z3950NormalizeAuthor','0','','If ON, Personal Name Authorities will replace authors in biblio.author','YesNo')
;
